<?php

date_default_timezone_set('Asia/Kolkata');
 class setFunctions{
  
    private $conn;
   
       
    // constructor
    function __construct() {
        require_once 'DB_Connect.php';
        require_once 'Automation.php';
        require_once 'updateFunctions.php';
        require_once 'getFunctions.php';

    
        require_once ('Common.php');
       
        $db = new Db_Connect();
        $this->conn = $db->connect();
        mysqli_set_charset($this->conn,'utf8');
       
    }
  
    function addStudentAttendence($staff_id,$strAttendence,$class_id,$section_id,$date,$school_code)
    {
        
        $auto= new Automation();

        $arrAttendence = json_decode($strAttendence, TRUE);
        //echo count($arrAttendence);
        $session_id=$this->getSessionByDate($date,$school_code);
        for ($i=0; $i <count($arrAttendence) ; $i++) 
        { 
               
              $enroll_no=$arrAttendence[$i]['student_enrollment_no'];
               //echo $enroll_no.'/'.$i.'//';
              $attendence=$arrAttendence[$i]['attendence'];
              $sql="INSERT INTO `tm_student_attendence` (`id`, `school_code`,`staff_id`,`student_enrollment_no`, `class_id`, `section_id`, `session_id`, `attendence_date`, `attendence`, `date_added`, `status`) 
                  VALUES (NULL,'$school_code','$staff_id','$enroll_no', '$class_id', '$section_id', '$session_id', '$date', '$attendence', CURRENT_TIMESTAMP, 'Active')";

                $result=mysqli_query($this->conn,$sql)or die ('Error in Add Student Attendence :'.mysqli_error($this->conn));
        }
        
        if($result)
        {
          $auto->NotifyStudentAttendance($staff_id,$strAttendence,$class_id,$section_id,$date,$session_id,$school_code);
           return true;
        }
        else{
            return false;
        }

        

    }

public function getSessionByDate($date,$school_code)
{

    $sql="SELECT `session_id` FROM `tm_session`  WHERE '$date' between `start_date`  AND `end_date` AND (`status`='Active' OR `status`='Current' OR `status`='Previous' OR `status`='Upcoming') AND `school_code`='$school_code'";

     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   session by date: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['session_id'];
        

}

public function getCurrentSession($school_code)
{

    $sql="SELECT `session_id` FROM `tm_session` WHERE `status`='current' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current session : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['session_id'];

}

public function registerStudent($school_code,$admDate,$session_id, $student_name,$dob,$gender,$community,$religion,$aadhar_no,$nationality, $board_id,$medium_id,$class_id,$section_id,$curAddress,$perAddress,$contact1,$contact_person1,  $contact_person_name1,$contact2,$contact_person2,$contact_person_name2,$email,$father_name,$father_occupation,$father_qualification,$father_aadhar,$mother_name,$mother_occupation,$mother_qualification,$mother_aadhar,$staff_id,$admission_type,$academic_mode,$caste,$admission_no)
{

        $common=new Common();
        $prefix_for_enroll_no=$common->getStudentEnrollmentPrefix($school_code);
        $start_digit=$common->getStudentEnrollmentStartDigit($school_code);

        $table='tm_student_admission';
        $col_id='student_code';
        $studentUniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        if($studentUniqueId==1)
        {
            $studentUniqueId=$common->getStudentEnrollmentCodeStartFrom($school_code);
        }
        $student_code=$prefix_for_enroll_no.str_pad($studentUniqueId,$start_digit,'0',STR_PAD_LEFT);

        $img_dir="PiZeroEduOkDocs/images/student"."/"."SC_".$school_code."/".$session_id."/".$class_id;
        $family_img_dir="PiZeroEduOkDocs/images/student"."/"."SC_".$school_code."/".$session_id."/".$class_id."/"."family";
        $password=mt_rand(10000,99999);
        $enroll_no=$student_code.$school_code;
     

    $sql="INSERT INTO `tm_student_admission` (`id`, `student_enrollment_no`,`school_code`,`student_code`,`sr_admission_no`,`staff_id`,`password`,`barcode_id`, `device_id`, `firebase_id`, `stu_name`, `gender`, `birthday`, `bloodgroup`, `religion`, `nationality`, `adharcard_no`, `community`,`caste`, `current_address`, `permanent_address`, `student_img_path`, `father_name`, `father_occupation`,`father_qualification`,`father_aadhar`, `father_img_path`, `mother_name`, `mother_occupation`, `mother_qualification`,`mother_aadhar`,`mother_img_path`, `email_id`, `date`, `status`) 
    VALUES (NULL, '$enroll_no','$school_code','$student_code','$admission_no','$staff_id','$password', NULL, NULL, NULL, '$student_name', '$gender', '$dob', '', '$religion', '$nationality', '$aadhar_no', '$community','$caste', '$curAddress', '$perAddress', '$img_dir', '$father_name', '$father_occupation','$father_qualification', '$father_aadhar','$family_img_dir', '$mother_name', '$mother_occupation','$mother_qualification','$mother_aadhar', '$family_img_dir', '$email', CURRENT_TIMESTAMP, 'Active');";

    $result=mysqli_query($this->conn,$sql)or die ('Error in registering student admission :'.mysqli_error($this->conn));

    if($result)
    {
         $StuRollNo=$this->SetStudentRollNumebr($session_id,$class_id,$section_id,$school_code);
         if($admission_type=="New")
         {
              $admission_type_id="ADMTYPE02";  
         }
         else{
            $admission_type_id="ADMTYPE01";
         }

        $sql="INSERT INTO `tm_student_class` (`id`,`school_code`, `student_enrollment_no`, `student_roll_no`, `session_id`, `class_id`, `section_id`, `board_id`, `medium_id`, `admission_type_id`, `academic_mode_id`, `registration_date`, `date_added`, `status`)
         VALUES (NULL, '$school_code','$enroll_no', '$StuRollNo', '$session_id', '$class_id', '$section_id', '$board_id', '$medium_id', '$admission_type_id', '$academic_mode', '$admDate', CURRENT_TIMESTAMP, 'Active')";
        $result2=mysqli_query($this->conn,$sql)or die ('Error in inserting  student class :'.mysqli_error($this->conn));

        if($result2)
        {
            $this->addStudentContact($enroll_no,$contact1,$contact_person1,$contact_person_name1,$school_code);
            if($contact2!="")
            {
                $this->addStudentContact($enroll_no,$contact2,$contact_person2,$contact_person_name2,$school_code);
            }
            return $enroll_no;
        }
        else{
            return $result2;
        }

    }
    else{
        return $result;
    }


    


}
function addStudentContact($enrollment_no,$contact,$contact_person,$contact_person_name,$school_code)
{

         $sql="INSERT INTO `tm_student_contact` (`id`,`school_code`, `student_enrollment_no`, `contact_number`, `contact_person_relation`, `contact_person_name`, `date_added`, `status`) 
         VALUES (NULL,'$school_code','$enrollment_no', '$contact', '$contact_person', '$contact_person_name', CURRENT_TIMESTAMP, 'Active');";
        $result2=mysqli_query($this->conn,$sql)or die ('Error in inserting  student contact :'.mysqli_error($this->conn));

        return $result2;

}
function SetStudentRollNumebr($session_id,$class_id,$section_id,$school_code)
{
    $sql="SELECT MAX( student_roll_no ) AS student_roll_no FROM  `tm_student_class` WHERE session_id =  '$session_id' AND section_id ='$section_id' AND class_id =  '$class_id' AND `school_code` ='$school_code' AND STATUS =  'active'";

    //echo $sql;
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting unique id :'.mysqli_error($this->conn));
    
        $row = $result->fetch_assoc();
        $data[]=$row;
    
        

    $id=$data[0]['student_roll_no'];
    //print_r($id);

    //return $id;
    if($id)
    {
        $newId=$id+1;
        return $newId;
    }

    else
    {    
        $newId=1;
        return $newId;
    }
    
}

public function updateStudentImgDir($enrollment_no,$img_dir_toupload)
{
        $sql="UPDATE  `tm_student_admission` SET  `student_img_path` = '$img_dir_toupload' WHERE  `student_enrollment_no` ='$enrollment_no'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating  student ing directory :'.mysqli_error($this->conn));
        if(mysqli_affected_rows($this->conn)>0)   
            {           
                return true;
            }
            else{           
                return false;
            }
}
public function addNotification($strRecipient,$message,$title,$sender_id,$department,$notification_type,$notification_bucket_id,$notification_bucket_caption,$school_code)
{

        $common=new Common();
        $session_id=$this->getCurrentSession($school_code);
        $table='tm_notification_master';
        $col_id='notification_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $notification_id='NTF'.str_pad($UniqueId, 5,'0',STR_PAD_LEFT);

    
       
        $arrRecipient = json_decode($strRecipient, TRUE);
        
        for ($i=0; $i <count($arrRecipient) ; $i++) { 
        
            $recipient=$arrRecipient[$i];
            

            $sql="INSERT INTO `tm_notification_master` (`id`,`school_code`,`notification_id`,`notification_type`,`notification_bucket_id`,`notification_bucket_caption`,`sender_id`,`session_id`, `recipient_id`, `notification_title`,`notification`,`department`, `date_added`, `status`)
             VALUES (NULL,'$school_code', '$notification_id','$notification_type','$notification_bucket_id','$notification_bucket_caption','$sender_id','$session_id', '$recipient','$title', '$message','$department',CURRENT_TIMESTAMP, 'Active')";
             ///echo $sql;
           
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding notification :'.mysqli_error($this->conn));

        }

        return $result;
}


public function addAdminNotification($strRecipient,$message,$title,$sender_id,$notification_type,$school_code)
{
    
        $common=new Common();
        $session_id=$this->getCurrentSession($school_code);
        $table='tm_notification_master_admin';
        $col_id='notification_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $notification_id='NTF'.str_pad($UniqueId,5,'0',STR_PAD_LEFT);

       
        $arrRecipient = json_decode($strRecipient, TRUE);
        for ($i=0; $i <count($arrRecipient) ; $i++) { 
        
            $recipient=$arrRecipient[$i];

            $sql="INSERT INTO `tm_notification_master_admin` (`id`,`school_code`, `notification_id`,`notification_type`,`sender_id`,`session_id`, `recipient_id`, `notification_title`,`notification`, `date_added`, `status`) 
            VALUES (NULL,'$school_code', '$notification_id','$notification_type','$sender_id','$session_id', '$recipient','$title', '$message',CURRENT_TIMESTAMP, 'Active')";
           
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding admin notification :'.mysqli_error($this->conn));

        }

        return $result;
}

public function addNotice($strRecipient,$notice,$staff_id,$ordered_by,$school_code)
{
        $notice=addcslashes($notice, "'");
        $common=new Common();
        $auto=new Automation();
        $session_id=$this->getCurrentSession($school_code);
        $table='tm_notice_board';
        $col_id='notice_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $notice_id='NTC'.str_pad($UniqueId, 5,'0',STR_PAD_LEFT);

        $arrRecipient = json_decode($strRecipient, TRUE);
        for ($i=0; $i <count($arrRecipient) ; $i++) { 
            $recipient=$arrRecipient[$i];
            
            $sql="INSERT INTO `tm_notice_board` (`id`,`school_code`, `notice_id`, `staff_id`,`session_id`, `notice`, `recipient_id`, `start_date`, `end_date`, `ordered_by`, `status`, `date_added`) 
            VALUES (NULL,'$school_code', '$notice_id', '$staff_id','$session_id', '$notice', '$recipient', NULL, NULL, '$ordered_by', 'Active', CURRENT_TIMESTAMP)";
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding notice :'.mysqli_error($this->conn));

        }
        if($result)
        {
            $auto->NotifyNoticeAdd($strRecipient,$staff_id,$school_code);
        }



        return $result;
}



public function registerStaffFirebaseTokenId($staff_id,$token,$device_id)
    {
        $sql="UPDATE  `tm_staff_master` SET  `firebase_id` =  '$token' , `device_id`='$device_id' WHERE `staff_id`='$staff_id'";

            $result=mysqli_query($this->conn,$sql)or die ('Error in updating firebase token id:'.mysqli_error($this->conn));
          if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }

        

    }

    public function clearStaffFirebaseTokenId($staff_id)
    {
        $sql="UPDATE  `tm_staff_master` SET  `firebase_id` =  '' , `device_id`='' WHERE `staff_id`='$staff_id'";

            $result=mysqli_query($this->conn,$sql)or die ('Error in clearing firebase token id:'.mysqli_error($this->conn));
            return $result;
           /* if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }*/
     

    }
    public function submitStudentFeeDetails($student_id,$class_id,$section_id,$session_id,$staff_id,
        $fee_details,$remark,$amount,$school_code)
    {
        $FLAG;     
        $strMonth;

        $auto=new Automation();
        $tdate = date('Y-m-d');
        $common=new Common();
       

        $table='tm_transaction_master';
        $col_id='reciept_no';
        $unique_id=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $reciept_no=''.str_pad($unique_id, 4,'0',STR_PAD_LEFT);
    
        $table='tm_transaction_master';
        $col_id='transaction_id';
        $unique_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $transaction_id='TXN'.str_pad($unique_id, 5,'0',STR_PAD_LEFT);

         $sql="INSERT INTO `tm_transaction_master` (`id`,`school_code`, `transaction_id`,`reciept_no`, `session_id`, `student_id`, `class_id`, `section_id`, `staff_id`, `paid_amount`, `remark`,`payment_mode`,`transaction_date`, `date_added`, `status`) 
         VALUES (NULL,'$school_code','$transaction_id','$reciept_no','$session_id', '$student_id', '$class_id', '$section_id', '$staff_id', '$amount', NULL,NULL,'$tdate', CURRENT_TIMESTAMP, '2')";
        
            $result=mysqli_query($this->conn,$sql)or die ('Error in inserting fee details:'.mysqli_error($this->conn));
            if($result)
            {
                    $arrFeeDetails = json_decode($fee_details, TRUE);
                   
                    for ($i=0; $i <count($arrFeeDetails) ; $i++) { 

                        $monthIsChecked=$arrFeeDetails[$i]["isChecked"];
                        
                        if($monthIsChecked=="true")
                        {
                        
                            $month2=$arrFeeDetails[$i]['month2'];
                            if($strMonth)
                            {
                                $strMonth=$month2;
                            }
                            else{
                                $strMonth=$strMonth.','.$month2;
                            }

                            $month=$arrFeeDetails[$i]['month'];
                            $applicable_fee=$arrFeeDetails[$i]['applicable_fee'];
                            $arrApplicable_fee = json_decode($applicable_fee, TRUE);
                        
                            for ($j=0; $j <count($arrApplicable_fee) ; $j++) { 
                                $isFeeChecked=$arrApplicable_fee[$j]['isChecked'];
                                if($isFeeChecked=="true")
                                {

                                $fee_id=$arrApplicable_fee[$j]['fee_id'];
                                $fee_value=$arrApplicable_fee[$j]['fee_value'];
                                $payable_amount=$arrApplicable_fee[$j]['payable_amount'];
                                $sql="INSERT INTO `tm_fee_payment` (`id`, `school_code`,`transaction_id`, `student_id`, `class_id`, `section_id`, `session_id`, `staff_id`, `fee_id`, `fee_payable`, `fee_paid`, `year_month`, `negotiated`, `date_added`, `status`) 
                                    VALUES (NULL,'$school_code', '$transaction_id', '$student_id', '$class_id', '$section_id', '$session_id', '$staff_id', '$fee_id', '$fee_value', '$payable_amount', '$month', 'No', CURRENT_TIMESTAMP, '2')";
                                    //echo $sql;
                    
                                 $result2=mysqli_query($this->conn,$sql)or die ('Error in inserting fee details2:'.mysqli_error($this->conn)); 
                                }
                            }
                        }
                       

                      
                }
                 $FLAG=true;

                $title="Fee Collection";
                $message="Transaction of fee,amount Rs ".$amount." for month(".$strMonth.") is successfully collected";
                $sender_id="System";
                $notification_type="Automation";
                $click_action="parents.ParentsFeeCardActivity";
                $auto->sendNotificationToStudent($student_id,$title,$message,$sender_id,$notification_type,$click_action,$school_code);
                $click_action="cms.FeeCollectionDetailsActivity";
                 $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code);

                            

            }
            else{
                $FLAG=false;
               
            }
            if($FLAG)
            {
                return $transaction_id;
            }
            else{
                return $FLAG;
            }

            
    }


 public function submitOldDueCollection($student_id,$class_id,$section_id,$session_id,$staff_id,
        $fee_details,$remark,$amount,$school_code)
    {

        //print_r($fee_details);
        $tdate = date('Y-m-d');
        $common=new Common();
        $table='tm_transaction_master';
        $col_id='transaction_id';
        $unique_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $transaction_id='TXN'.str_pad($unique_id, 5,'0',STR_PAD_LEFT);

        $table='tm_transaction_master';
        $col_id='reciept_no';
        $unique_id=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $reciept_no=''.str_pad($unique_id, 4,'0',STR_PAD_LEFT);
    
        $transaction_for='OLD_DUE';

         $sql="INSERT INTO `tm_transaction_master` (`id`,`school_code`, `transaction_id`,`reciept_no`, `session_id`, `student_id`, `class_id`, `section_id`, `staff_id`, `paid_amount`, `remark`,`payment_mode`,`transaction_date`,`transaction_for`, `date_added`, `status`) 
         VALUES (NULL,'$school_code','$transaction_id','$reciept_no','$session_id', '$student_id', '$class_id', '$section_id', '$staff_id', '$amount', NULL,NULL,'$tdate','$transaction_for', CURRENT_TIMESTAMP, '2')";
        
            $result=mysqli_query($this->conn,$sql)or die ('Error in inserting old due details:'.mysqli_error($this->conn));
            if($result)
            {
                    $arrFeeDetails = json_decode($fee_details, TRUE);
                    
                    for ($i=0; $i <count($arrFeeDetails) ; $i++) { 

                        $IsChecked=$arrFeeDetails[$i]["checked"];                      
                        if($IsChecked=="true")
                        {
                        
                                $due_id=$arrFeeDetails[$i]['due_id'];
                                $fee_value=$arrFeeDetails[$i]['amount'];
                                $payable_amount=$arrFeeDetails[$i]['payable_amount'];
                                $sql="INSERT INTO `tm_fee_old_due_payment` (`id`, `school_code`, `transaction_id`, `student_id`, `class_id`, `section_id`, `session_id`, `staff_id`, `due_id`, `amount_payable`, `amount_paid`, `date_added`, `status`) 
                                VALUES (NULL, '$school_code', '$transaction_id', '$student_id', '$class_id', '$section_id', '$session_id', '$staff_id', '$due_id', '$fee_value', '$payable_amount', CURRENT_TIMESTAMP, '2')";
                                    //echo $sql;
                    
                                 $result2=mysqli_query($this->conn,$sql)or die ('Error in inserting old due details2:'.mysqli_error($this->conn)); 
                        
                        }

                      
                    }
                    return $transaction_id;

            }
            else{
                return $result;
            }

            
    }

public function saveHomeWork($class_id,$section_id,$subject_id,$session_id,$homework,$img_dir_toupload,$homework_date,$school_code)
{

        $auto=new Automation();
        $dbget=new getFunctions();
        $common=new Common();
        $table='tm_class_homework';
        $col_id='homework_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $homework_id='HW'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $sql="INSERT INTO `tm_class_homework` (`id`,`school_code`, `homework_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `homework_date`, `homework_img`, `home_work`, `date_added`, `status`) 
        VALUES (NULL,'$school_code', '$homework_id', '$session_id', '$class_id', '$section_id', '$subject_id', '$homework_date', '$img_dir_toupload', '$homework', CURRENT_TIMESTAMP, 'Active')";
        
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding  homework :'.mysqli_error($this->conn));

        if($result)
        {
                $subject_name=$dbget->getSubjectName($subject_id,$school_code);
                $title="Homework";
                $message="New homework of subject ".$subject_name." is uploaded";
                $sender_id="System";
                $notification_type="Automation";
                $click_action="parents.ParentsHomeWorkMainActivity";
                $recipient=$class_id.'#'.$section_id;
                $auto->sendNotificationToStudent($recipient,$title,$message,$sender_id,$notification_type,$click_action,$school_code);
        }


        return $result;
}



    public function registerHolidays($holiday_occasion,$holiday_remark,$holiday_type,$holiday_start_date,$holiday_end_date,$school_code)
    {

        $common=new Common();
        $session_id=$this->getCurrentSession($school_code);
        $table='tm_holiday_list';
        $col_id='holiday_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $holiday_id='HLD'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_holiday_list` (`id`,`school_code`, `holiday_id`, `start_holiday_date`, `end_holiday_date`, `holiday_Occasion`, `holiday_remark`, `holiday_type`, `session_id`, `date_added`, `status`) 
            VALUES (NULL,'$school_code', '$holiday_id', '$holiday_start_date', '$holiday_end_date', '$holiday_occasion', '$holiday_remark', '$holiday_type', '$session_id', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in registering holidays :'.mysqli_error($this->conn));

        

        return $result;

    }

    public function saveImageToGallery($sender_id,$caption,$description,$session_id,$img_dir_toupload)
    {

        $common=new Common();
        $table='tm_event_gallery';
        $col_id='image_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $image_id='IMG'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_event_gallery` (`id`, `sender_id`, `session_id`, `image_id`, `caption`, `description`, `img_path`, `date_added`, `status`) 
            VALUES (NULL, '$sender_id', '$session_id', '$image_id', '$caption', '$description', '$img_dir_toupload', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding image to gallery :'.mysqli_error($this->conn));

        

        return $result;

    }


    public function registerStaff($school_code,$StaffName,$phone,$email,$Department_id, $doj,$dob,$gender,$religion,$aadhar_no,$nationality, $role,$login_type,$address,$qualification)
    {
        $common=new Common();
        $staff_prefix_code=$common->getStaffIdPrefix($school_code);
        $staff_startdigit=$common->getStaffIdStartDigit($school_code);

        $session_id=$this->getCurrentSession($school_code);
        $table='tm_staff_master';
        $col_id='staff_code';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        if($UniqueId==1)
        {
            $UniqueId=$common->getStaffIdCodeStartFrom($school_code);
        }
        $staff_code=$staff_prefix_code.str_pad($UniqueId, $staff_startdigit,'0',STR_PAD_LEFT);
        $staff_id=$staff_code.$school_code;
        $password=mt_rand(10000,99999);

            $sql="INSERT INTO `tm_staff_master` (`id`, `session_id`, `staff_id`,`school_code`,`staff_code`, `aadhar_no`, `barcode_id`, `device_id`, `firebase_id`, `staff_name`,`department_id`, `staff_gender`, `staff_phone`, `staff_email`, `password`, `staff_dob`, `registration_date`, `joining_date`, `staff_role`, `login_type`, `staff_religion`, `nationality`, `staff_address`, `date`, `status`) 
            VALUES (NULL, '$session_id', '$staff_id', '$school_code','$staff_code','$aadhar_no', NULL, NULL, NULL, '$StaffName', '$Department_id','$gender', '$phone', '$email', '$password', '$dob', CURRENT_TIMESTAMP, '$doj', '$role', '$login_type', '$religion', '$nationality', '$address', CURRENT_TIMESTAMP, 'Active');";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in registering staff :'.mysqli_error($this->conn));

        if($result)
        {
            $status=$this->addStaffQualification($staff_id,$qualification,$school_code);
            return $staff_id;
        }
        else{
           return $result; 
        }

        

    }

    function addStaffQualification($staff_id,$strQualification,$school_code)
    {
            $arrQualification = json_decode($strQualification, TRUE);
            for ($i=0; $i <count($arrQualification) ; $i++) 
            { 

                    $staff_degree=$arrQualification[$i]['degree'];
                     $staff_university=$arrQualification[$i]['university'];
                    $staff_passing_year=$arrQualification[$i]['passing_year'];
                    $staff_percentage=$arrQualification[$i]['percentage'];

              $sql="INSERT INTO `tm_staff_education` (`id`, `school_code`,`staff_id`, `staff_degree`, `staff_university`, `staff_passing_year`, `staff_percentage`, `date_added`, `status`)
               VALUES (NULL, '$school_code','$staff_id', '$staff_degree', '$staff_university', '$staff_passing_year', '$staff_percentage',CURRENT_TIMESTAMP, 'Active');";

                $result=mysqli_query($this->conn,$sql)or die ('Error in Add Staff Qualification :'.mysqli_error($this->conn));
            }
    
            return $result;

    }

    function updateStaffProfilePic($staff_id,$img_dir_toupload)
    {
         $sql="UPDATE  `tm_staff_master` SET  `staff_image_path`='$img_dir_toupload'  WHERE `staff_id`='$staff_id'";

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff profile picture:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {           
                return true;
            }
            else{
            
                return false;
            }
    }

    function updateStaffPassword($staff_id,$new_password)
    {
         $sql="UPDATE  `tm_staff_master` SET  `password`='$new_password'  WHERE `staff_id`='$staff_id'";

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff password:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {           
                return true;
            }
            else{           
                return false;
            }
    }
    

     public function registerDemoRequest($SchoolName,$phone,$email,$Location, $ContactPerson,$Designation)
    {

        $common=new Common();
        $table='tm_demo_request';
        $col_id='request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $request_id='RST'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_demo_request` (`id`, `request_id`, `school_name`, `school_location`, `contact_person`, `designation`, `phone`, `email`, `date_added`, `status`) 
            VALUES (NULL, '$request_id', '$SchoolName', '$Location', '$ContactPerson', '$Designation', '$phone', '$email', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in registering demo request :'.mysqli_error($this->conn));

        

        return $result;

    }

     public function AddDepartment($department_name,$department_head)
    {

        $common=new Common();
        $table='tm_department';
        $col_id='department_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $department_id='DMT'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_department` (`id`, `department_id`, `department_name`, `department_head`, `date_added`, `status`)
             VALUES (NULL, '$department_id', '$department_name', '$department_head', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in registering department :'.mysqli_error($this->conn));

        

        return $result;

    }
    
    public function AddNewClass($class_name,$class_teacher,$board_id,$medium_id,$school_code)
    {

        $common=new Common();
        $session_id=$this->getCurrentSession($school_code);
        $table='tm_class';
        $col_id='class_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $class_id='CLS'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_class` (`id`,`school_code`, `class_id`, `class_name`, `session_id`, `board_id`, `medium_id`, `date`, `status`) 
            VALUES (NULL, '$school_code','$class_id', '$class_name', '$session_id', '$board_id', '$medium_id', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new  class :'.mysqli_error($this->conn));

        

        return $result;

    }
     public function AddClassSubject($class_id,$subject_id,$subject_code,$book_name,$school_code)
    {

        $session_id=$this->getCurrentSession($school_code);
            $sql="INSERT INTO `tm_class_subject` (`id`,`school_code`, `session_id`, `class_id`, `subject_id`, `subject_code`, `book_name`, `date_added`, `status`)
             VALUES (NULL,'$school_code', '$session_id', '$class_id', '$subject_id', '$subject_code', '$book_name', CURRENT_TIMESTAMP, 'Active')";
        
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new subject in  class :'.mysqli_error($this->conn));

        

        return $result;

    }
     public function AddNewMasterSubject($subject_name,$school_code)
    {
    

        $common=new Common();
        $table='tm_subject';
        $col_id='subject_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $subject_id='SBT'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_subject` (`id`,`school_code`, `subject_id`, `subject_name`, `date`, `status`) VALUES (NULL, '$school_code','$subject_id', '$subject_name', CURRENT_TIMESTAMP, 'Active')";
        
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in addind new subject :'.mysqli_error($this->conn));

        

        return $result;

    }
     public function createPasscode($staff_id,$passcode)
    {
            $sql="INSERT INTO `tm_passcode` (`id`, `staff_id`, `passcode`, `date_added`, `status`) 
            VALUES (NULL, '$staff_id', '$passcode', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding passcode :'.mysqli_error($this->conn));

    
        return $result;

    }

    public function AddClassFee($session_id,$class_id,$fee_id,$fee_value,$fee_value_for_existing_student,$applicable_month,$mode_id,$is_special_fee,$school_code)
    {

            $sql="INSERT INTO `tm_class_fee` (`id`,`school_code`, `session_id`, `class_id`, `fee_id`, `fee_value`, `applicable_month`, `mode_id`, `date`, `status`)
             VALUES (NULL, '$school_code','$session_id', '$class_id', '$fee_id', '$fee_value', '$applicable_month', '$mode_id', CURRENT_TIMESTAMP, 'Active')";
        
            
            $result1=mysqli_query($this->conn,$sql)or die ('Error in adding fee in  class :'.mysqli_error($this->conn));

        if($is_special_fee=='1')
        {

            $sql="INSERT INTO `tm_fee_registration_existing_student` (`id`, `school_code`,`session_id`, `class_id`, `fee_id`, `fee_value`, `applicable_month`, `mode_id`, `date`, `status`)
             VALUES (NULL, '$school_code','$session_id', '$class_id', '$fee_id', '$fee_value_for_existing_student', '$applicable_month', '$mode_id', CURRENT_TIMESTAMP, 'Active')";
        
            
            $result2=mysqli_query($this->conn,$sql)or die ('Error in adding fee in  class :'.mysqli_error($this->conn));
            return $result2;
        }
        else{
            return $result1;
        }

    }

    public function AddNewApplicaleFee($fee_name,$fee_type,$is_special_fee,$school_code)
    {
        $common=new Common();
        $table='tm_fee_applicable';
        $col_id='fee_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $fee_id='FEE'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);



        if($is_special_fee=='0')
        {
            $remark="Class Fee";
             $sql="INSERT INTO `tm_fee_applicable` (`id`, `school_code`, `fee_id`, `fee_name`, `fee_type`, `remark`, `service_id`, `is_special_fee`, `date`, `status`)
             VALUES (NULL, '$school_code', '$fee_id', '$fee_name', '$fee_type', '$remark', NULL, '$is_special_fee', CURRENT_TIMESTAMP, 'Active')";
        }
        else{
            $remark='Class Fee(Different for new admission and readmission)';
            $sql="INSERT INTO `tm_fee_applicable` (`id`, `school_code`, `fee_id`, `fee_name`, `fee_type`, `remark`, `service_id`, `is_special_fee`, `date`, `status`)
             VALUES (NULL, '$school_code', '$fee_id', '$fee_name', '$fee_type', '$remark', NULL, '$is_special_fee', CURRENT_TIMESTAMP, 'Active')"; 
        }

           
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new  fee :'.mysqli_error($this->conn));      
        return $result;

    }

    public function addStudentSiblings($student_id,$siblings,$school_code)
    {

            $sql="SELECT `sib_enrollment_no` FROM `tm_student_siblings` WHERE INSTR(`sib_enrollment_no` ,'$student_id') AND `status`='Active'";
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting siblings: '.mysqli_error($this->conn));

            if(mysqli_num_rows($result) > 0)
            {

                while ($row = $result->fetch_assoc()) {
                   $sib_enrollment_no=$row['sib_enrollment_no']; 
                    
                }
                $siblings_data=$sib_enrollment_no.','.$siblings;
                $sql="UPDATE `tm_student_siblings` SET `sib_enrollment_no` = '$siblings_data' WHERE INSTR(`sib_enrollment_no` ,'$student_id')";    
                $result2=mysqli_query($this->conn,$sql)or die ('Error in updating siblings:'.mysqli_error($this->conn));
                if(mysqli_affected_rows($this->conn)>0)   
                {
            
                    return true;
                }
                 else{
            
                return false;
                }
            }
            else{
                $siblings_data=$student_id.','.$siblings;
                $sql="INSERT INTO `tm_student_siblings` (`id`, `school_code`,`sib_enrollment_no`, `date_added`, `status`) 
                VALUES (NULL,'$school_code','$siblings_data', CURRENT_TIMESTAMP,'Active')";
            
                $result3=mysqli_query($this->conn,$sql)or die ('Error in adding siblings :'.mysqli_error($this->conn));      
                return $result3;
            }
                                     

    }
    public function AddAdmissionRequest($student_name,$gender,$community,$class,$father_name,$contact_number)
    {

        $common=new Common();
        $table='tm_admission_request';
        $col_id='request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $request_id='RST'.str_pad($UniqueId, 5,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_admission_request` (`id`, `request_id`, `student_name`, `gender`, `community`, `class`, `father_name`, `contact_number`, `date_added`, `status`) 
            VALUES (NULL, '$request_id', '$student_name', '$gender', '$community', '$class', '$father_name', '$contact_number', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding adm request :'.mysqli_error($this->conn));      
        return $result;

    }

     public function AddNewRoute($route_name,$start_from,$end_to,$route_distance,$school_code)
    {

        $common=new Common();
        $table='tm_route_master';
        $col_id='route_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $route_id='RTE'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_route_master` (`id`,`school_code`,`route_id`, `route_name`, `start_from`, `end_to`, `route_distance`, `date_added`, `status`) 
            VALUES (NULL,'$school_code', '$route_id', '$route_name', '$start_from', '$end_to', '$route_distance', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new route :'.mysqli_error($this->conn));  
          if($result)  
          {
            /*$arrPickUpPoint = json_decode($pickup_points, TRUE);      
            for ($i=0; $i <count($arrPickUpPoint) ; $i++) 
            { 
                unset($pickup_point_id);
                $pickup_point_id=$arrPickUpPoint[$i]['pickup_point_id'];
                 $pickup_pont_name=$arrPickUpPoint[$i]['pickup_pont_name'];
                 $distance_from_school=$arrPickUpPoint[$i]['distance_from_school'];
                 if(empty($pickup_point_id))
                 {
                    $table='tm_route_pickup_points';
                    $col_id='pickup_point_id';
                     $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
                     $pickup_point_id='PKP'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
                 }
                 
                 $sql2="INSERT INTO `tm_route_pickup_points` (`id`, `route_id`, `pickup_point_id`, `pickup_pont_name`, `distance_from_school`, `geolocation`, `date_added`, `status`) VALUES (NULL, '$route_id', '$pickup_point_id', '$pickup_pont_name', '$distance_from_school', NULL, CURRENT_TIMESTAMP, 'Active')";
            
                   $result2=mysqli_query($this->conn,$sql2)or die ('Error in adding pickup points :'.mysqli_error($this->conn));

            }
            return $result2;*/

          } 
         
          return $result; 
        

    }
    public function AddNewVehicle($vehicle_name,$vehicle_number,$vehicle_type,$school_code)
    {

        $common=new Common();
        $table='tm_vehicle_master';
        $col_id='vehicle_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $vehicle_id='VHL'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_vehicle_master` (`id`, `school_code`,`vehicle_id`, `vehicle_name`, `vehicle_number`, `vehicle_type`, `status`, `date_added`) 
            VALUES (NULL,'$school_code','$vehicle_id', '$vehicle_name ', '$vehicle_number', '$vehicle_type', 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new  vehicle :'.mysqli_error($this->conn)); 
            if($result)
            {

                //$this->addVehiclePickupRouteAndRound($vehicle_id,$vehicle_route);

            }

        return $result;

    }
    public function addVehiclePickupRouteAndRound($vehicle_id,$vehicle_route)
    {

        unset($arrRoute);
        $arrRoute = json_decode($vehicle_route, TRUE);      
        for ($i=0; $i <count($arrRoute) ; $i++) { 

                $route_id=$arrRoute[$i]['route_id'];
                $stat_pickup_time=$arrRoute[$i]['stat_pickup_time'];
                $pickup_points=$arrRoute[$i]['pickup_points'];

                $common=new Common();
                $table='tm_vehicle_pickup_round';
                $col_id='pickup_round_id';
                $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
                $pickup_round_id='PKPR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

               $sql="INSERT INTO `tm_vehicle_pickup_round` (`id`, `pickup_round_id`, `round_name`, `vehicle_id`, `route_id`, `start_pickup`, `date_added`, `status`)
                VALUES (NULL, '$pickup_round_id', NULL, '$vehicle_id', '$route_id', '$stat_pickup_time', CURRENT_TIMESTAMP, 'Active')";
            
                 $result=mysqli_query($this->conn,$sql)or die ('Error in adding vehicle pickup round :'.mysqli_error($this->conn));  
                 if($result)
                 {
                    $this->addVehicleActivePickupPoints($pickup_round_id,$route_id,$vehicle_id,$pickup_points);
                 }

             
        }

       return $result;     

    }
     public function addVehicleActivePickupPoints($pickup_round_id,$route_id,$vehicle_id,$pickup_points)
    {
        unset($arrPickup_points);
        $arrPickup_points = json_decode($pickup_points, TRUE);      
        //print_r($arrPickup_points);

        for ($i=0; $i <count($arrPickup_points) ; $i++) { 

                $pickup_time=$arrPickup_points[$i]['pickup_time'];
                $pickup_point_id=$arrPickup_points[$i]['pickup_point_id'];
                
               $sql="INSERT INTO `tm_vehicle_route_active_pickups` (`id`, `pickup_round_id`, `vehicle_id`, `route_id`, `active_pickup_points`, `pickup_time`, `pickup_index`, `date_added`, `status`) VALUES (NULL, '$pickup_round_id', '$vehicle_id', '$route_id', '$pickup_point_id', '$pickup_time', '1', CURRENT_TIMESTAMP, 'Active')";
            
                 $result=mysqli_query($this->conn,$sql)or die ('Error in adding vehicle active pickup point :'.mysqli_error($this->conn));  

             
        }

       return $result;     

    }

    public function addTransportStudent($staff_id,$student_id,$session_id,$class_id,$section_id,$vehicle_id,$pickup_round_id,$route_id,$pickup_point_id,$pickup_point_name,$pickup_time,$transport_fee,$concession_granted,$applicable_month,$service_id,$school_code)
    {

            $common=new Common();
            $auto=new Automation();
            if(empty($pickup_point_id))
            {
                
                     $table='tm_route_pickup_points';
                     $col_id='pickup_point_id';
                     $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);               
                     $pickup_point_id='PKP'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
                     $sql2="INSERT INTO `tm_route_pickup_points` (`id`,`school_code`, `route_id`, `pickup_point_id`, `pickup_point_name`, `distance_from_school`, `geolocation`, `date_added`, `status`) VALUES (NULL,'$school_code', '$route_id', '$pickup_point_id', '$pickup_point_name', '$distance_from_school', NULL, CURRENT_TIMESTAMP, 'Active')";               
            
                   $result2=mysqli_query($this->conn,$sql2)or die ('Error in adding pickup points :'.mysqli_error($this->conn));
            }


            mysqli_query("START TRANSACTION");
            $sql="INSERT INTO `tm_transport_student` (`id`,`school_code`, `student_id`, `session_id`, `vehicle_id`,`route_id`, `pickup_point_id`, `pickup_time`,`transport_fee`,`concession_granted`,`date_applicable`,`applicable_month`,`status`, `date_added`)
             VALUES (NULL,'$school_code', '$student_id', '$session_id', '$vehicle_id', '$route_id', '$pickup_point_id','$pickup_time','$transport_fee','$concession_granted',CURRENT_TIMESTAMP,'$applicable_month','Active', CURRENT_TIMESTAMP)";
            
            
            $result1=mysqli_query($this->conn,$sql)or die ('Error in adding new  transport student :'.mysqli_error($this->conn)); 

             if($result1)   
             {           
                $sql="INSERT INTO `tm_student_services` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `service_id`, `service_remark`, `status`, `date_added`)
               VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$service_id', NULL, 'Active', CURRENT_TIMESTAMP)";
            
                $result2=mysqli_query($this->conn,$sql)or die ('Error in init transport student :'.mysqli_error($this->conn));

                if($result2)
                {
                    $arrApplicable_month= explode(',', $applicable_month);
                    for ($i=0; $i <count($arrApplicable_month) ; $i++) { 
                         $month=$arrApplicable_month[$i];
                         $service_fee=$transport_fee;
                         $discount='0';
                         $net_service_fee=$transport_fee;

                    $sql="INSERT INTO `tm_student_services_fee` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `service_id`, `applicable_month`, `service_fee`, `discount`, `is_discount_granted`, `net_service_fee`, `status`, `date_added`) VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$service_id', '$month', '$service_fee', '$discount', '0', '$net_service_fee', 'Active', CURRENT_TIMESTAMP)";
                
                    $result3=mysqli_query($this->conn,$sql)or die ('Error in init transport student :'.mysqli_error($this->conn));    
                    }

                   
                       
                }  
        }
        if($result1 && $result2 && $result3) {
            mysqli_query("COMMIT");
            $setting_id='NFTS0001';
          
            $settins=$common->getNotificationSettings($setting_id,$school_code);
            if($settins[0]['notify_admin']=='1')
            {
              
                $title="Transport Service";
                 
                $message="Transport Service  of Student ".$common->getStudentName($student_id)." Added by staff ".$common->getStaffName($staff_id);
               
                $sender_id="System";
                $notification_type="Automation";
                $click_action="cms.TransportStudentListActivity";
                $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code);
               
            }

            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }     
        
    }


    public function addHostalStudent($staff_id,$student_id,$session_id,$class_id,$section_id,$block_id,$room_no,$caution_money,$hostal_fee,$is_mess_taken,$applicable_month,$service_id,$school_code)
    {

            $common=new Common();
            $auto=new Automation();
            
            mysqli_query("START TRANSACTION");

            $sql="INSERT INTO `tm_hostal_student` (`id`, `school_code`, `student_id`, `session_id`, `block_id`, `room_no`, `caution_money`, `hostal_fee`, `is_mess_taken`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$student_id', '$session_id', '$block_id', '$room_no', '$caution_money', '$hostal_fee', '$is_mess_taken', 'Active', CURRENT_TIMESTAMP)";
            
            
            $result1=mysqli_query($this->conn,$sql)or die ('Error in adding new  hostal student :'.mysqli_error($this->conn)); 

             if($result1)   
             {           
                $sql="INSERT INTO `tm_student_services` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `service_id`, `service_remark`, `status`, `date_added`)
               VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$service_id', NULL, 'Active', CURRENT_TIMESTAMP)";
            
                $result2=mysqli_query($this->conn,$sql)or die ('Error in init service  student :'.mysqli_error($this->conn));

                if($result2)
                {
                    $arrApplicable_month= explode(',', $applicable_month);
                    for ($i=0; $i <count($arrApplicable_month) ; $i++) { 
                         $month=$arrApplicable_month[$i];
                         $service_fee=$hostal_fee;
                         $discount='0';
                         $net_service_fee=$hostal_fee;

                    $sql="INSERT INTO `tm_student_services_fee` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `service_id`, `applicable_month`, `service_fee`, `discount`, `is_discount_granted`, `net_service_fee`, `status`, `date_added`) VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$service_id', '$month', '$service_fee', '$discount', '0', '$net_service_fee', 'Active', CURRENT_TIMESTAMP)";
                
                    $result3=mysqli_query($this->conn,$sql)or die ('Error in init service student :'.mysqli_error($this->conn));    
                    }

                   
                       
                }  
        }
        if($result1 && $result2 && $result3) {
            mysqli_query("COMMIT");
            $setting_id='NFTS0002';
            $settins=$common->getNotificationSettings($setting_id,$school_code);
            if($settins[0]['notify_admin']=='1')
            {
                $title="Hostal Service";
                $message="Hostal Service  of Student ".$common->getStudentName($student_id)." Added by staff ".$common->getStaffName($staff_id);
                $sender_id="System";
                $notification_type="Automation";
                $click_action="cms.HostalStudentListActivity";
                $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code); 
            }

            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }     
        
    }

     public function AddTransportServiceMonth($staff_id,$transport_service_month,$student_id,$class_id,$section_id,$session_id,$service_id,$school_code)
    {
            $common=new Common();
            $auto=new Automation();
            
            $arr_transport_service_month = explode(',', $transport_service_month);
            //print_r("mmm"+$arr_transport_service_month);

            $sql="SELECT `transport_fee` FROM `tm_transport_student` WHERE `student_id`='$student_id' AND `session_id`='$session_id' AND `school_code`='$school_code'"; 
            //echo $sql;  
              $result=mysqli_query($this->conn,$sql)or die ('Error in getting  transport default fee : '.mysqli_error($this->conn));
             if($result)
             {
                   $row = $result->fetch_assoc();
                   $transport_fee=$row['transport_fee'];   
                   //echo "string";          
                     for ($i=0; $i <count($arr_transport_service_month) ; $i++) {
                        $applicable_month=$arr_transport_service_month[$i];
                         $sql="INSERT INTO `tm_student_services_fee` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `service_id`, `applicable_month`, `service_fee`, `discount`, `is_discount_granted`, `net_service_fee`, `status`, `date_added`)
                          VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$service_id', '$applicable_month', '$transport_fee', '0', '0', '$transport_fee', 'Active', CURRENT_TIMESTAMP)";
                    
                    
                         $result2=mysqli_query($this->conn,$sql)or die ('Error in adding new  transport service month :'.mysqli_error($this->conn)); 
                   }
                            
            
                            
             } 
             if($result2)
             {

                    $title="Transport Service Month";
                    $message="Transport Service Month:".$transport_service_month." of  student ".$common->getStudentName($student_id)." Added by staff ".$common->getStaffName($staff_id);
                    $sender_id="System";
                    $notification_type="Automation";
                    $click_action="cms.TransportStudentListActivity";
                    $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code); 
             }

           
                
            return $result2;

    }


    public function AddHostalServiceMonth($staff_id,$service_month,$student_id,$class_id,$section_id,$session_id,$service_id,$school_code)
    {
            $common=new Common();
            $auto=new Automation();
            
            $arr_service_month = explode(',', $service_month);
            //print_r("mmm"+$arr_transport_service_month);

            $sql="SELECT `hostal_fee` FROM `tm_hostal_student` WHERE `student_id`='$student_id' AND `session_id`='$session_id' AND `school_code`='$school_code'"; 
            //echo $sql;  
              $result=mysqli_query($this->conn,$sql)or die ('Error in getting  hostal default fee : '.mysqli_error($this->conn));
             if($result)
             {
                   $row = $result->fetch_assoc();
                   $hostal_fee=$row['hostal_fee'];   
                   //echo "string";          
                     for ($i=0; $i <count($arr_service_month) ; $i++) {
                        $applicable_month=$arr_service_month[$i];
                         $sql="INSERT INTO `tm_student_services_fee` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `service_id`, `applicable_month`, `service_fee`, `discount`, `is_discount_granted`, `net_service_fee`, `status`, `date_added`)
                          VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$service_id', '$applicable_month', '$hostal_fee', '0', '0', '$hostal_fee', 'Active', CURRENT_TIMESTAMP)";
                    
                    
                         $result2=mysqli_query($this->conn,$sql)or die ('Error in adding new  hostal service month :'.mysqli_error($this->conn)); 
                   }
                            
            
                            
             } 
             if($result2)
             {

                    $title="Hostal Service Month";
                    $message="Hostal Service Month:".$service_month." of  student ".$common->getStudentName($student_id)." Added by staff ".$common->getStaffName($staff_id);
                    $sender_id="System";
                    $notification_type="Automation";
                    $click_action="cms.HostalStudentListActivity";
                    $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code); 
             }

           
                
            return $result2;

    }

    public function createExam($session_id,$exam_name,$exam_date,$participating_class,$school_code)
    {
 
        $common=new Common();
        $table='tm_exam_master';
        $col_id='exam_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $exam_id='EXM'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_exam_master` (`id`,`school_code`, `exam_id`, `exam_name`, `session_id`, `start_date`, `status`, `date_added`) 
            VALUES (NULL,'$school_code','$exam_id', '$exam_name', '$session_id', '$exam_date', '1', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in create  new  exam :'.mysqli_error($this->conn)); 
            if($result)
            {
                    $this->AddParticipatingClass($exam_id,$participating_class,$school_code);
            }

        return $result;

    }
     public function AddParticipatingClass($exam_id,$participating_class,$school_code)
    {

            $arrParticipating_class = json_decode($participating_class, TRUE); 
            for ($i=0; $i <count($arrParticipating_class) ; $i++) { 

                    $isChecked=$arrParticipating_class[$i]['isChecked'];
                    $class_id=$arrParticipating_class[$i]['class_id'];
                    $section_id=$arrParticipating_class[$i]['section_id'];
                    if(!isset($section_id))
                    {
                        $section_id="No";
                    }
                    $subject=$arrParticipating_class[$i]['subject'];

                    if($isChecked=="true")
                    {
                        unset($arrSubject_ids);
                        $arrSubject = json_decode($subject, TRUE); 
                        for ($j=0; $j <count($arrSubject) ; $j++) { 

                            $isChecked2=$arrSubject[$j]['isChecked'];
                            if($isChecked2=="true")
                            {
                                $arrSubject_ids[]=$arrSubject[$j]['subject_id'];
                            }
                        }
                        $strSubject_ids= implode(',', $arrSubject_ids);

                        $sql="INSERT INTO `tm_exam_participating_class` (`id`,`school_code`, `exam_id`, `class_id`, `section_id`, `subject_ids`, `status`, `date_added`) 
                        VALUES (NULL,'$school_code', '$exam_id', '$class_id', '$section_id', '$strSubject_ids', 'Active', CURRENT_TIMESTAMP)";
            
                        $result=mysqli_query($this->conn,$sql)or die ('Error in create  exam participating clas:'.mysqli_error($this->conn)); 
                    }

                          
            }

        return $result;

    }


    public function AddAllStudentMark($session_id,$exam_id,$class_id,$section_id,$subject_id,$marks,$school_code)
    {
        $arrMarks = json_decode($marks, TRUE); 
            for ($i=0; $i <count($arrMarks) ; $i++) { 
                $student_id="SUI001";
                $max_mark="100";
                $obtain_mark="85";
                $result=$this->AddStudentMark($session_id,$exam_id,$class_id,$section_id,$subject_id,$student_id,$max_mark,$obtain_mark);
            }
        return $result;    
    }
    public function AddStudentMarkAllSubjects($student_id,$session_id,$exam_id,$class_id,$section_id,$str_subjects,$school_code)
    {
        $arrSubjects = json_decode($str_subjects, TRUE); 
        // print_r($arrSubjects);
            for ($i=0; $i <count($arrSubjects) ; $i++) { 
                $subject_id=$arrSubjects[$i]['subject_id'];
                $subject_paper=$arrSubjects[$i]['subject_paper'];
                //echo $subject_paper.'/';
                // print_r($subject_paper);

              
                $result=$this->AddStudentMark($session_id,$exam_id,$class_id,$section_id,$subject_id,$student_id,$subject_paper,$school_code);
            }
        return $result;    
    }

    public function AddStudentMark($session_id,$exam_id,$class_id,$section_id,$subject_id,$student_id,$mark_details,$school_code)
    {

        $FLAG=false;

        $arrmark_details = json_decode($mark_details, TRUE);

        for ($i=0; $i <sizeof($arrmark_details) ; $i++) { 
            $exam_paper_id=$arrmark_details[$i]['exam_paper_id'];

            $strMark=$arrmark_details[$i]['mark'];
            $arrMark = json_decode($strMark, TRUE);
            //echo $strMark.'/';

            if(sizeof($arrMark)!=0)
            {
                
                    $is_mark_system=$arrMark[0]['is_mark_system'];
                    $obtained_mark=$arrMark[0]['obtained_mark'];
                    $max_mark=$arrMark[0]['max_mark'];
                    $is_grade_system=$arrMark[0]['is_grade_system'];
                    $max_grade=$arrMark[0]['max_grade'];
                    $grade_obtained=$arrMark[0]['grade_obtained'];

                    $sql="SELECT * FROM `tm_exam_student_mark`  WHERE `exam_id`='$exam_id' AND `exam_paper_id`='$exam_paper_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `student_id`='$student_id' AND `school_code`='$school_code'" ;
             
                    $result=mysqli_query($this->conn,$sql)or die ('Error in getting paper data: '.mysqli_error($this->conn));
                    if(mysqli_affected_rows($this->conn)>0)
                    {
                        

                     $sql="UPDATE `tm_exam_student_mark` SET `is_mark_system` = '$is_mark_system',`obtained_mark` = '$obtained_mark',`max_mark` = '$max_mark',`is_grade_system` = '$is_grade_system',`max_grade` = '$max_grade',`grade_obtained` = '$grade_obtained' WHERE `exam_id`='$exam_id' AND `exam_paper_id`='$exam_paper_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `student_id`='$student_id' AND `school_code`='$school_code'";

                         
                        $result1=mysqli_query($this->conn,$sql)or die ('Error in updating student mark:'.mysqli_error($this->conn));  
                       if(mysqli_affected_rows($this->conn)>0)   
                        {
                    
                           $FLAG=true;
                        }
                        else{
                           $FLAG=false; 
                        }
                    }
                    else{

                        $sql="INSERT INTO `tm_exam_student_mark` (`id`, `school_code`, `exam_id`, `session_id`, `class_id`, `section_id`, `student_id`, `subject_id`, `exam_paper_id`, `is_mark_system`, `obtained_mark`, `max_mark`, `is_grade_system`, `max_grade`, `grade_obtained`, `status`, `date_added`) 
                        VALUES (NULL, '$school_code', '$exam_id', '$session_id', '$class_id', '$section_id', '$student_id', '$subject_id', '$exam_paper_id', '$is_mark_system', '$obtained_mark', '$max_mark', '$is_grade_system', '$max_grade', '$grade_obtained', 'Active', CURRENT_TIMESTAMP)";
                        

                        $result2=mysqli_query($this->conn,$sql)or die ('Error in adding student mark:'.mysqli_error($this->conn));
                         
                         if($result2)
                         {
                            $FLAG=true;
                         }
                         else{
                            $FLAG=false;

                         }
                    }
          }

        }
        return FLAG;

       
    }

    
    public function createExamReportCard($report_card_pattern_id,$session_id,$report_card_name,$str_exam_list,$school_code)
    {
 
        $get=new getFunctions();
        $FLAG_COUNT=false;
        $common=new Common();
        $table='tm_exam_report_card';
        $col_id='report_card_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $report_card_id='RC'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_exam_report_card` (`id`, `school_code`, `session_id`, `report_card_id`, `report_card_name`, `report_card_type`, `report_card_pattern_id`, `status_code`, `status_name`, `date_added`)
                VALUES (NULL, '$school_code', '$session_id', '$report_card_id', '$report_card_name', 'ANNUAL', '$report_card_pattern_id', '1', 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in create  new  exam report card :'.mysqli_error($this->conn)); 
            if(mysqli_affected_rows($this->conn)>0)
            {
                    $arr_exam_list=json_decode($str_exam_list, TRUE);
                    //print_r($arr_exam_list);
                    for ($i=0; $i <count($arr_exam_list); $i++) { 

                        $exam_id=$arr_exam_list[$i]['concerned_exam_id'];
                        $sql2="INSERT INTO `tm_exam_report_card_concerned_exams` (`id`, `school_code`, `session_id`, `report_card_id`, `report_card_type`, `concerned_exams`, `status_code`, `status_name`, `date_added`)
                           VALUES (NULL, '$school_code', '$session_id', '$report_card_id', 'ANNUAL', '$exam_id', '1', 'Active', CURRENT_TIMESTAMP)";
                                
                        $result2=mysqli_query($this->conn,$sql2)or die ('Error in adding reportcard concerned exam :'.mysqli_error($this->conn)); 
                    
                        

                    }
                    
            }

        return $result;

    }


    ///Time Table............................................................................
    public function createTimeSlot($time_slot_name,$school_start_time,$prayer_time,$period_start,$period_duration,$number_of_period,$period_before_lunch,$period_after_lunch)
    {

        $common=new Common();
        $table='tm_time_slot';
        $col_id='time_slot_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $time_slot_id='TSL'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_time_slot` (`id`, `time_slot_id`, `time_slot_name`, `school_start_time`, `prayer_time`, `period_start`, `period_duration`, `number_of_period`, `period_before_lunch`, `period_after_lunch`, `date_added`, `status`) 
            VALUES (NULL, '$time_slot_id', '$time_slot_name', '$school_start_time', '$prayer_time', '$period_start', '$period_duration', '$number_of_period', '$period_before_lunch', '$period_after_lunch', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in creating time slot :'.mysqli_error($this->conn)); 

        return $result;

    }
    public function AddStaffAttendance($authorized_staff_id,$staff_id,$attendance_date,$attendance,$school_code)
    {


        $session_id=$this->getSessionByDate($attendance_date,$school_code);
        $sql="UPDATE `tm_staff_attendance` SET `attendance` = '$attendance' WHERE `staff_id`='$staff_id' AND `session_id`='$session_id' AND `attendance_date`='$attendance_date' AND `school_code`='$school_code' ";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff attendance:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
                 $sql="INSERT INTO `tm_staff_attendance` (`id`,`school_code`, `authorized_staff_id`, `staff_id`, `session_id`, `attendance_date`, `attendance`, `date_added`, `status`) 
                VALUES (NULL,'$school_code', '$authorized_staff_id', '$staff_id', '$session_id', '$attendance_date', '$attendance',CURRENT_TIMESTAMP, 'Active')";
                    
                $result=mysqli_query($this->conn,$sql)or die ('Error in adding staff attendance :'.mysqli_error($this->conn)); 

                return $result;

            }
       

    }

    public function vendorRegistration($vendor_name,$business_name,$address,$phone,$email,$description,$school_code)
    {

        $common=new Common();
        $table='tm_vendor';
        $col_id='vendor_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $vendor_id='VID'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_vendor` (`id`, `school_code`, `vendor_id`, `vendor_name`, `business_name`, `address`, `phone`, `email`, `description`, `vendor_img_dir`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$vendor_id', '$vendor_name', '$business_name', '$address', '$phone', '$email', '$description', NULL, 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in registering vendor :'.mysqli_error($this->conn)); 

        return $result;

    }


     public function addTransportFeeStructure($session_id,$distance_from,$distance_to,$transport_fee,$vehicle_type)
    {

            $sql="INSERT INTO `tm_transport_fee_structure` (`id`, `session_id`, `distance_from`, `distance_to`, `transport_fee`, `vehicle_type`, `status`, `date_added`)
             VALUES (NULL, '$session_id', '$distance_from', '$distance_to', '$transport_fee', '$vehicle_type', 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding transport fee :'.mysqli_error($this->conn)); 

           return $result;

    }


     public function AddAccessoriesCategory($category_name,$school_code)
    {

        $common=new Common();
        $table='tm_accessories_category';
        $col_id='category_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $category_id='CAT'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_accessories_category` (`id`,`school_code`, `category_id`, `category_name`, `date_added`, `status`) 
            VALUES (NULL,'$school_code', '$category_id', '$category_name', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding accessories category :'.mysqli_error($this->conn)); 

        return $result;

    }

     public function AddAccessoriesPublication($publication_name,$address,$description,$school_code)
    {

        $common=new Common();
        $table='tm_accessories_publications';
        $col_id='publication_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $publication_id='PUB'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_accessories_publications` (`id`,`school_code`, `publication_id`, `publication_name`, `address`, `description`, `date_added`, `status`) 
            VALUES (NULL, '$school_code','$publication_id', '$publication_name', '$address', '$description', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding accessories publication :'.mysqli_error($this->conn)); 

        return $result;

    }
     public function AddClassActivity($session_id,$staff_id,$class_id,$section_id,$subject_id,$subject_part_id,$subject_lession_id,$lession_name,$pages,$paragraph,$class_activity,$any_remark)

    {

        $common=new Common();
        $table='tm_class_activity';
        $col_id='activity_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id);
        $activity_id='AVT'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_class_activity` (`id`, `session_id`, `activity_id`, `staff_id`, `class_id`, `section_id`, `subject_id`, `subject_part_id`, `subject_lession_id`, `lession_name`, `pages`, `paragraph`, `class_activity`, `any_remark`, `date`, `status`) 
                VALUES (NULL, '$session_id', '$activity_id', '$staff_id', '$class_id', '$section_id', '$subject_id', '$subject_part_id', '$subject_lession_id', '$lession_name', '$pages', '$paragraph', '$class_activity', '$any_remark', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding class activity :'.mysqli_error($this->conn)); 

        return $result;

    }

 public function AddAccessoriesProduct($session_id,$category_id,$product_name,$class_for,$vendor_id,$quantity,$mrp,$cp,$sp,$remark,$school_code)

    {

        $common=new Common();
        $table='tm_accessories_product';
        $col_id='product_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $product_id='P'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_accessories_product` (`id`, `school_code`,`session_id`, `product_id`, `product_name`, `category`, `in_stock`,`remark`, `status`, `date_added`) 
            VALUES (NULL,'$school_code', '$session_id', '$product_id', '$product_name', '$category_id',  '$quantity','$remark', 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding accessories product :'.mysqli_error($this->conn)); 
            if($result)
            {
                $result2=$this->AddAccessoriesProductForClass($product_id,$class_for,$school_code);
                if($result2)
                {
                    $result3=$this->AddAccessoriesStock($session_id,$product_id,$class_for,$vendor_id,$quantity,$mrp,$cp,$sp,$school_code);
               
                     return $result3;

                }
                
            }

        return $result;

    }
    public function AddAccessoriesStock($session_id,$product_id,$class_for,$vendor_id,$quantity,$mrp,$cp,$sp,$school_code)

    {

        $common=new Common();
        $table='tm_accessories_stock';
        $col_id='stock_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $stock_id='STK'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_accessories_stock` (`id`,`school_code`, `stock_id`, `product_id`, `session_id`, `vendor_id`, `quantity_recieved`, `quantity_in_stock`,`mrp`, `cp`, `sp`, `status`, `date_added`) 
            VALUES (NULL,'$school_code', '$stock_id', '$product_id', '$session_id', '$vendor_id', '$quantity','$quantity','$mrp', '$cp', '$sp', 'InSell', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding accessories stock :'.mysqli_error($this->conn)); 
        
        return $result;

    }
     public function AddAccessoriesProductForClass($product_id,$class_for,$school_code)
    {
            $arrClass=explode('#', $class_for);

            for ($i=0; $i <count($arrClass) ; $i++) { 
                
                $class_id=$arrClass[$i];
                $sql="INSERT INTO `tm_accessories_for_class` (`id`,`school_code`, `product_id`, `class_id`, `status`, `date_added`) 
                VALUES (NULL,'$school_code', '$product_id', '$class_id', 'Active', CURRENT_TIMESTAMP)";
            
                $result=mysqli_query($this->conn,$sql)or die ('Error in adding accessories for class :'.mysqli_error($this->conn)); 
            }

            
        
        return $result;

    }

public function submitAccessoriesToStudent($student_id,$class_id,$section_id,$session_id,$staff_id,
        $accessories_details,$remark,$net_payable_amount,$school_code)
    {

        $tdate = date('Y-m-d');
        $transaction_for="ACCESSORIES";
        $common=new Common();
        $table='tm_transaction_master';
        $col_id='transaction_id';
        $unique_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $transaction_id='TXN'.str_pad($unique_id, 5,'0',STR_PAD_LEFT);

        $table='tm_transaction_master';
        $col_id='reciept_no';
        $unique_id=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $reciept_no=''.str_pad($unique_id, 4,'0',STR_PAD_LEFT);
    

         $sql="INSERT INTO `tm_transaction_master` (`id`,`school_code`, `transaction_id`,`reciept_no`, `session_id`, `student_id`, `class_id`, `section_id`, `staff_id`, `paid_amount`, `remark`,`payment_mode`,`transaction_date`,`transaction_for`, `date_added`, `status`) 
         VALUES (NULL,'$school_code', '$transaction_id','$reciept_no', '$session_id', '$student_id', '$class_id', '$section_id', '$staff_id', '$net_payable_amount', NULL,NULL,'$tdate','$transaction_for', CURRENT_TIMESTAMP, '2')";
        
            $result=mysqli_query($this->conn,$sql)or die ('Error in inserting accessories details:'.mysqli_error($this->conn));
            if($result)
            {
                    $arrAccessoriesDetails = json_decode($accessories_details, TRUE);
                    for ($i=0; $i <count($arrAccessoriesDetails) ; $i++) { 

                       $product_id=$arrAccessoriesDetails[$i]['product_id'];
                       $quantity=$arrAccessoriesDetails[$i]['quantity'];
                       $payable_amount=$arrAccessoriesDetails[$i]['payable_amount'];
                       $paid_amount=$arrAccessoriesDetails[$i]['paid_amount'];

                       $str_in_sell_stock=$arrAccessoriesDetails[$i]['in_sell_stock'];
                       $arrInSellStock = json_decode($str_in_sell_stock, TRUE);
                       $product_mrp=$arrInSellStock[0]['mrp'];
                       $product_cp=$arrInSellStock[0]['cp'];
                       $product_sp=$arrInSellStock[0]['sp'];
                       $stock_id=$arrInSellStock[0]['stock_id'];
                       


                        $sql="INSERT INTO `tm_accessories_to_student` (`id`,`school_code`, `transaction_id`, `student_id`, `class_id`, `section_id`, `session_id`, `staff_id`, `product_id`,`stock_id`, `product_mrp`, `product_cp`, `product_sp`, `quantity`, `payable_amount`, `paid_amount`, `payment_date`, `negotiated`, `due_settlement`, `date_added`, `status`)
                         VALUES (NULL,'$school_code', '$transaction_id', '$student_id', '$class_id', '$section_id', '$session_id', '$staff_id', '$product_id', '$stock_id','$product_mrp', '$product_cp', '$product_sp', '$quantity', '$payable_amount', '$paid_amount', '$tdate', 'No', 'No', CURRENT_TIMESTAMP, '2')";
                    
                                 $result2=mysqli_query($this->conn,$sql)or die ('Error in inserting accessories details2:'.mysqli_error($this->conn)); 

                        
                         if($result2)
                         {
                            $update=new updateFunctions();
                            $TAG_SOLD="SOLD";
                            $update->updateAccessoriesStock($stock_id,$product_id,$quantity,$TAG_SOLD);
                         }        
                                

                      
                }
                return $transaction_id;

            }
            else{
                return $result;
            }

            
    }

    public function registerNewSchool($school_name,$school_address,$country,$state,$admin_name,$admin_phone)
    {

        $common=new Common();
        $table='tm_school_master';
        $col_id='school_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $school_id='SCL'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);


        $sql="SELECT `pattern_id`,`pattern_name`,`pattern_chars`,`code_length`,`max_code`,`current_code_count` FROM `tm_school_code_pattern` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  code pattern  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
        }

        $c=explode(',', $data[0]['pattern_chars']);
        $length=$data[0]['code_length'];
        $school_code=$this->generateSchoolCode($c,$length);

            $sql="INSERT INTO `tm_school_master` (`id`, `school_id`, `school_code`, `school_name`, `school_address`, `country`, `state`,`admin_name`,`admin_phone`, `date_added`, `status`)
             VALUES (NULL, '$school_id', '$school_code', '$school_name', '$school_address', '$country', '$state','$admin_name','$admin_phone', CURRENT_TIMESTAMP, 'Active')";
            
        $result=mysqli_query($this->conn,$sql)or die ('Error in registering new school:'.mysqli_error($this->conn)); 

        if($result)
        {
               $sql="SELECT  `school_id`, `school_code`, `school_name`, `school_address`, `country`, `state`,`admin_name`,`admin_phone` FROM `tm_school_master` WHERE `school_code`='$school_code' AND `status`='Active'";   
               $result=mysqli_query($this->conn,$sql)or die ('Error in school details '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data2[] = $row;
                 }
                return $data2;

        }
        else{
                return $result;  
          }

         
    }


public function generateSchoolCode($CharSet,$CodeLength) 
{ 
    $n = sizeof($CharSet);
    $k =$CodeLength; 
    $found=NULL;
    $count=0;
    //echo $k."\n";
    $found=$this->generateSchoolCodeRec($count,$found,$CharSet, "", $n,$k); 
    //echo $found."\n";
    if($found)
    {
        
        return $found;
    }
    else{
        $k++;
        $found=$this->generateSchoolCode($CharSet,$k);
    }
    return $found;
    
} 

public function generateSchoolCodeRec(&$count,&$found,$CharSet,$prefix,$n, $k) 
{ 
      
    // Base case: k is 0, 
    // print prefix
    
    if ($k == 0)  
    { 
        $sql="SELECT * FROM `tm_school_master` WHERE `school_code`='$prefix'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school code : '.mysqli_error($this->conn));
        $num_rows = mysqli_num_rows($result);
        //echo $num_rows . '<br />';

        if ($num_rows==0) 
         {
            $found=$prefix;
         }


        $count++;
        //echo $prefix."\n"; 
        //echo $count."\n"; 
       

        return $found; 
    } 
  
    for ($i = 0; $i < $n; ++$i) 
    { 
  

    if($found!=NULL)
    {
        //echo "found".$found."\n";
        return $found;
    }
    else{
         // Next character of input added 
        $newPrefix = $prefix . $CharSet[$i]; 
        //echo $newPrefix."\n"; 
          
        // k is decreased, because  
        // we have added a new character 
        $this->generateSchoolCodeRec($count,$found,$CharSet, $newPrefix,  
                                $n, $k - 1);  

    }
       
    } 

    return $found;
}

    public function registerNewSchoolPremium($school_name,$school_address,$country,$state,$admin_name,$admin_phone)
    {

        $common=new Common();
        $table='tm_school_master';
        $col_id='school_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $school_id='SCL'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);


        $sql="SELECT `pattern_id`,`pattern_name`,`pattern_chars`,`code_length`,`max_code`,`current_code_count` FROM `tm_school_code_pattern` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  code pattern  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
        }

        $c=explode(',', $data[0]['pattern_chars']);
        $length=$data[0]['code_length'];
        $school_code_tmp=$this->generateSchoolCodePremium($c,$length);
        $school_code='P'.$school_code_tmp;
      

            $sql="INSERT INTO `tm_school_master` (`id`, `school_id`, `school_code`, `school_name`, `school_address`, `country`, `state`,`admin_name`,`admin_phone`, `date_added`, `status`)
             VALUES (NULL, '$school_id', '$school_code', '$school_name', '$school_address', '$country', '$state','$admin_name','$admin_phone', CURRENT_TIMESTAMP, 'Active')";
            
        $result=mysqli_query($this->conn,$sql)or die ('Error in registering new school:'.mysqli_error($this->conn)); 

        if($result)
        {
               $sql="SELECT  `school_id`, `school_code`, `school_name`, `school_address`, `country`, `state`,`admin_name`,`admin_phone` FROM `tm_school_master` WHERE `school_code`='$school_code' AND `status`='Active'";   
               $result=mysqli_query($this->conn,$sql)or die ('Error in school details '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data2[] = $row;
                 }
                return $data2;

        }
        else{
                return $result;  
          }

         
    }


public function generateSchoolCodePremium($CharSet,$CodeLength) 
{ 
    $n = sizeof($CharSet);
    $k =$CodeLength; 
    $found=NULL;
    $count=0;
    //echo $k."\n";
    $found=$this->generateSchoolCodeRecPremium($count,$found,$CharSet, "", $n,$k); 
    //echo $found."\n";
    if($found)
    {
        
        return $found;
    }
    else{
        $k++;
        $found=$this->generateSchoolCodePremium($CharSet,$k);
    }
    return $found;
    
} 

public function generateSchoolCodeRecPremium(&$count,&$found,$CharSet,$prefix,$n, $k) 
{ 
      
    // Base case: k is 0, 
    // print prefix
    
    if ($k == 0)  
    { 
        $school_code='P'.$prefix;
        $sql="SELECT * FROM `tm_school_master` WHERE `school_code`='$school_code'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school code : '.mysqli_error($this->conn));
        $num_rows = mysqli_num_rows($result);
        //echo $num_rows . '<br />';

        if ($num_rows==0) 
         {
            $found=$prefix;
         }


        $count++;
        //echo $prefix."\n"; 
        //echo $count."\n"; 
       

        return $found; 
    } 
  
    for ($i = 0; $i < $n; ++$i) 
    { 
  

    if($found!=NULL)
    {
        //echo "found".$found."\n";
        return $found;
    }
    else{
         // Next character of input added 
        $newPrefix = $prefix . $CharSet[$i]; 
        //echo $newPrefix."\n"; 
          
        // k is decreased, because  
        // we have added a new character 
        $this->generateSchoolCodeRecPremium($count,$found,$CharSet, $newPrefix,  
                                $n, $k - 1);  

    }
       
    } 

    return $found;
} 


 public function AddNewUpcomingSession($session_name,$start_date,$end_date,$school_code)

    {

        $auto= new Automation();
        $common=new Common();
        $table='tm_session';
        $col_id='session_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $session_id='SSN'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_session` (`id`, `school_code`, `session_id`, `session_name`, `start_date`, `end_date`, `date_added`, `status`) 
             VALUES (NULL, '$school_code', '$session_id', '$session_name', '$start_date', '$end_date', CURRENT_TIMESTAMP, 'Upcoming')";
            //echo $sql;
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new session :'.mysqli_error($this->conn));

            if($result)
            {
                
                $this->copySessionData($school_code,$session_id);
            } 
        
        return $result;

    }
    public function copySessionData($school_code,$new_session_id)
    {

        $get=new getFunctions();
        $FLAG=false;
        $prev_data=$get->getPreviousSession($school_code);
        $session_id=$prev_data[0]['session_id']; 
            
        $dependent_table=$this->getNewSessionDependentTables();
        for ($i=0; $i <count($dependent_table) ; $i++) { 
              $table_name=$dependent_table[$i]['table_name'];
              $date_field=$dependent_table[$i]['date_field'];

              
               $sql="DROP TEMPORARY TABLE IF EXISTS tmp";
              $result=mysqli_query($this->conn,$sql)or die ('Error in delete temp table :'.mysqli_error($this->conn));
             

              $sql="CREATE TEMPORARY TABLE tmp SELECT * FROM $table_name WHERE `school_code`='$school_code' AND `session_id`='$session_id' ORDER BY `id` ASC";
                
              $result=mysqli_query($this->conn,$sql)or die ('Error in creating temp table :'.mysqli_error($this->conn));
            if($result)   
            {
                 $sql="UPDATE tmp SET `session_id`='$new_session_id',`id`='',$date_field=CURRENT_TIMESTAMP WHERE `school_code`='$school_code'";
                
                 $result2=mysqli_query($this->conn,$sql)or die ('Error in creating temp table :'.mysqli_error($this->conn));
                  if(mysqli_affected_rows($this->conn)>0)   
                 {
                      $sql="INSERT INTO $table_name SELECT * FROM tmp WHERE `school_code`='$school_code'";
                
                      $result3=mysqli_query($this->conn,$sql)or die ('Error in creating temp table :'.mysqli_error($this->conn));
                      if($result3)
                      {
                        $FLAG=true;
                      }
                 
                
                  }

                
            }
            
        }

        return $FLAG;

    }
     public function getNewSessionDependentTables()
    {
     
        $sql="SELECT `table_name`, `date_field` FROM `tm_dependent_new_session` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  dependent table new session: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                        $data[] = $row;
                 }
        
          return $data; 
     }




 public function AddNewSession($session_name,$start_date,$end_date,$board_name,$medium_name,$student_id_prefix,$student_id_start_from,$student_id_start_digit,$staff_id_prefix,$staff_id_start_from,$staff_id_start_digit,$strClass,$school_code)

    {

        $auto= new Automation();
        $common=new Common();
        $table='tm_session';
        $col_id='session_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $session_id='SSN'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_session` (`id`, `school_code`, `session_id`, `session_name`, `start_date`, `end_date`, `date_added`, `status`) 
             VALUES (NULL, '$school_code', '$session_id', '$session_name', '$start_date', '$end_date', CURRENT_TIMESTAMP, 'Current')";
            //echo $sql;
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new session :'.mysqli_error($this->conn));

            if($result)
            {
                $this->AddNewBoard($session_id,$board_name,$school_code);
                $this->AddNewMedium($session_id,$medium_name,$school_code);
                $this->AddStudentPrefix($student_id_prefix,$student_id_start_from,$student_id_start_digit,$school_code);
                $this->AddStaffPrefix($staff_id_prefix,$staff_id_start_from,$staff_id_start_digit,$school_code);
                $this->FeeAndSpecialSetting($school_code);
                $this->AddSchoolDetails($school_code);
                $this->AddClass_SessionSetting($session_id,$strClass,$school_code);
                $this->setAdsControl($school_code);


                $admin_name=$this->getAdminName($school_code);
                $admin_phone=$this->getAdminPhone($school_code);
                $Department_id="DMT001";
                $role="Admin";
                $login_type="Admin";


                $staff_id=$this->registerStaff($school_code,$admin_name,$admin_phone,$email,$Department_id, $doj,$dob,$gender,$religion,$aadhar_no,$nationality, $role,$login_type,$address,$qualification);

                $auto->NotifyNewSchoolRegistration($school_code);

                return $staff_id;

                

            } 
        
        return $result;

    }

    public function getAdminName($school_code)
    {

    $sql="SELECT `admin_name` FROM `tm_school_master` WHERE `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  admin name : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['admin_name'];

    }
     public function getAdminPhone($school_code)
    {

    $sql="SELECT `admin_phone` FROM `tm_school_master` WHERE `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  admin phone : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['admin_phone'];

    }

    public function AddNewBoard($session_id,$board_name,$school_code)
    {
        $common=new Common();
        $table='tm_board';
        $col_id='board_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $board_id='B'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

        $sql="INSERT INTO `tm_board`(`id`, `session_id`, `school_code`, `board_id`, `board_name`, `date`, `status`) VALUES (NULL,'$session_id','$school_code','$board_id','$board_name',CURRENT_TIMESTAMP,'Active')";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding new board :'.mysqli_error($this->conn));

        return $result;

    }
     public function AddNewMedium($session_id,$medium_name,$school_code)
    {
        $common=new Common();
        $table='tm_medium';
        $col_id='medium_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $medium_id='M'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

        $sql="INSERT INTO `tm_medium`(`id`, `session_id`, `school_code`, `medium_id`, `medium_name`, `date`, `status`) VALUES (NULL,'$session_id','$school_code','$medium_id','$medium_name',CURRENT_TIMESTAMP,'Active')";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding new medium :'.mysqli_error($this->conn));

        return $result;

    }
    public function setAdsControl($school_code)
    {
        
        $sql="INSERT INTO `tm_ads_control` (`id`, `school_code`, `ads_type`, `ads_name`, `ads_network`, `status`, `date`) 
        VALUES (NULL, '$school_code', 'A001', 'Banner', 'Admob', 'Active', CURRENT_TIMESTAMP),
         (NULL, '$school_code', 'A002', 'Native', 'Admob', 'Active', CURRENT_TIMESTAMP), 
         (NULL, '$school_code', 'A003', 'Interstitial', 'Admob', 'Active', CURRENT_TIMESTAMP)";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in setting ads controls :'.mysqli_error($this->conn));

        return $result;

    }

    public function AddStudentPrefix($student_id_prefix,$student_id_start_from,$student_id_start_digit,$school_code)
    {
        
        $sql="INSERT INTO `prefix_master` (`id`, `school_code`, `prefix_id`, `prefix`, `code_start_from`, `start_digit`, `prefix_name`, `date_added`, `status`) 
        VALUES (NULL, '$school_code', 'PFX0001', '$student_id_prefix', '$student_id_start_from', '$student_id_start_digit', 'Student id', CURRENT_TIMESTAMP, 'Active')";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding student prefix :'.mysqli_error($this->conn));

        return $result;

    }
    public function AddStaffPrefix($staff_id_prefix,$staff_id_start_from,$staff_id_start_digit,$school_code)
    {
        
        $sql="INSERT INTO `prefix_master` (`id`, `school_code`, `prefix_id`, `prefix`, `code_start_from`, `start_digit`, `prefix_name`, `date_added`, `status`) 
        VALUES (NULL, '$school_code', 'PFX0002', '$staff_id_prefix', '$staff_id_start_from', '$staff_id_start_digit', 'Staff id', CURRENT_TIMESTAMP, 'Active')";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding staff prefix :'.mysqli_error($this->conn));

        return $result;

    }
    public function FeeAndSpecialSetting($school_code)
    {

            $remark="Class Fee";
            $remark_special='Class Fee(Different for new admission and readmission)';
            $remark_vas="Value Added Service Fee";
            

        
        $sql="INSERT INTO `tm_fee_applicable` (`id`, `school_code`, `fee_id`, `fee_name`, `fee_type`, `remark`, `service_id`, `is_special_fee`, `date`, `status`) 
        VALUES (NULL, '$school_code', 'FEE001', 'Admission Fee','CLASSFEE', '$remark_special', NULL, '1',  CURRENT_TIMESTAMP, 'Active'),
         (NULL, '$school_code', 'FEE002', 'Transportation Fee','VAS', '$remark_vas', 'SRV001', '0',CURRENT_TIMESTAMP, 'Active'), 
         (NULL, '$school_code', 'FEE003', 'Tuition Fee','CLASSFEE', '$remark', NULL, '0', CURRENT_TIMESTAMP, 'Active'),
          (NULL, '$school_code', 'FEE004', 'Exam Fee', 'CLASSFEE', '$remark', NULL, '0', CURRENT_TIMESTAMP, 'Active')";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding fee setting  :'.mysqli_error($this->conn));



        $sql2="INSERT INTO `tm_fee_special` (`id`, `school_code`, `fee_id`, `fee_name`, `remark`, `date_added`, `status`) 
        VALUES (NULL, '$school_code', 'FEE001', 'Admission Fee', 'Vary for new registration and existing student registration', CURRENT_TIMESTAMP, 'Active'), (NULL, '$school_code', 'FEE002', 'Transportation Fee', 'Transportation fee is set student by student', CURRENT_TIMESTAMP, 'Active')";
            
                  $result2=mysqli_query($this->conn,$sql2)or die ('Error in adding fee setting  :'.mysqli_error($this->conn));          

        return $result2;

    }
     public function AddSchoolDetails($school_code)
    {
        
        $sql="INSERT INTO `tm_school_details` (`id`, `school_code`, `school_logo_path`, `school_tag_line`, `school_estb_year`, `school_reg_no`, `school_lat_lang`, `officail_contact_no1`, `officail_contact_no2`, `officail_email`, `website`, `scanned_sign_clerk`, `scanned_sing_principle`, `date`, `status`) VALUES (NULL, '$school_code', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, CURRENT_TIMESTAMP, 'Active')";
            
                  $result=mysqli_query($this->conn,$sql)or die ('Error in scholl details  :'.mysqli_error($this->conn));
     

        return $result;

    }
     public function AddClass_SessionSetting($session_id,$strClass,$school_code)
    {

        $common=new Common();
        $arrClass=json_decode($strClass, TRUE);

        for ($i=0; $i <count($arrClass) ; $i++) { 
           if($arrClass[$i]['selected']=="true")
           {
                $table='tm_class';
                $col_id='class_id';
                $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
                $class_id='CLS'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);
                $class_name=$arrClass[$i]['class_name'];

                $sql="INSERT INTO `tm_class` (`id`, `school_code`, `class_id`, `class_name`, `session_id`, `board_id`, `medium_id`, `date`, `status`) 
                VALUES (NULL, '$school_code', '$class_id', '$class_name', '$session_id', 'B001', 'M001', CURRENT_TIMESTAMP, 'Active')";
                    
                          $result=mysqli_query($this->conn,$sql)or die ('Error in adding new class :'.mysqli_error($this->conn));
             }
        }


        

        return $result;

    }

    public function AddClassSection($staff_id,$section_id,$section_name,$class_id,$school_code)
    {

            $update=new updateFunctions();
            $dbget=new getFunctions();
            $session_id=$this->getCurrentSession($school_code);
            $section=$dbget->getClassSection($class_id,$session_id,$school_code);

            $sql="INSERT INTO `tm_class_section` (`id`,`school_code`, `section_id`, `class_id`, `session_id`, `section_name`,`date`, `status`) 
            VALUES (NULL, '$school_code','$section_id', '$class_id', '$session_id', '$section_name', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding class section :'.mysqli_error($this->conn)); 

            if($result)
            {
                if (empty($section)) {
                    $existing_section_id="No";
                    $new_section_id=$section_id;
                    $update->updateAllStudentSectionShift($staff_id,$existing_section_id,$new_section_id,$class_id,$session_id,$school_code);
               }

            }

           return $result;

    }


    public function AddDueSettlementRequest($sender_id,$class_id,$section_id,$student_id,$session_id,$fee_id,$applicable_month,$due_amount,$due_payment_status,$school_code)
    {

        $auto= new Automation();
        $common=new Common();
        $table='tm_fee_due_settlement_request';
        $col_id='settlement_request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $settlement_request_id='DSR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $sql="INSERT INTO `tm_fee_due_settlement_request` (`id`,`school_code`, `settlement_request_id`, `sender_id`, `approved_by`, `student_id`, `session_id`, `class_id`, `section_id`, `fee_id`, `applicable_month`, `due_amount`, `due_payment_status`, `settlement_status`, `date_added`, `status`, `isTrashed`, `trashed_date`) 
            VALUES (NULL,'$school_code', '$settlement_request_id', '$sender_id', NULL, '$student_id', '$session_id', '$class_id', '$section_id', '$fee_id', '$applicable_month', '$due_amount', '$due_payment_status', '1', CURRENT_TIMESTAMP, 'Active', '0', NULL)";
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding due settlement request :'.mysqli_error($this->conn));

        if($result)
        {
                    $title="Due Settlement Request";
                    $message="New Due Settlement Request is registered from student ".$common->getStudentName($student_id);
                    $sender_id="System";
                    $notification_type="Automation";
                    $click_action="admin.SettlementActivity";
                    $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code);    
        }
        

        return $result;

    }

    public function SettleFee($student_id,$class_id,$section_id,$session_id,$sender_id,
        $fee_details,$remark,$amount,$school_code)
    {
        
        $auto= new Automation();
        $common=new Common();
        $table='tm_fee_due_settlement_request';
        $col_id='settlement_request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $settlement_request_id='DSR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $arrFeeDetails = json_decode($fee_details, TRUE);

                    for ($i=0; $i <count($arrFeeDetails) ; $i++) { 

                        $monthIsChecked=$arrFeeDetails[$i]["isChecked"];
                        if($monthIsChecked=="true")
                        {

                        
                            $month=$arrFeeDetails[$i]['month'];
                            $applicable_fee=$arrFeeDetails[$i]['applicable_fee'];
                            $arrApplicable_fee = json_decode($applicable_fee, TRUE);
                        
                            for ($j=0; $j <count($arrApplicable_fee) ; $j++) { 
                                $isFeeChecked=$arrApplicable_fee[$j]['isChecked'];
                                if($isFeeChecked=="true")
                                {

                                $fee_id=$arrApplicable_fee[$j]['fee_id'];
                                $fee_value=$arrApplicable_fee[$j]['fee_value'];
                                $payable_amount=$arrApplicable_fee[$j]['payable_amount'];
                                $sql="INSERT INTO `tm_fee_due_settlement_request` (`id`,`school_code`, `settlement_request_id`, `sender_id`, `approved_by`, `student_id`, `session_id`, `class_id`, `section_id`, `fee_id`, `applicable_month`, `due_amount`, `due_payment_status`, `settlement_status`, `date_added`, `status`, `isTrashed`, `trashed_date`) 
                                VALUES (NULL,'$school_code', '$settlement_request_id', '$sender_id', '$sender_id', '$student_id', '$session_id', '$class_id', '$section_id', '$fee_id', '$month', '$payable_amount', '1', '2', CURRENT_TIMESTAMP, 'Active', '0', NULL)";
                            
                                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding  settlement fee :'.mysqli_error($this->conn));
                                }
                            }
                        }

                      
                }

        return $result;    
    }


    public function AddFeeSettlementRequest($student_id,$class_id,$section_id,$session_id,$sender_id,
        $fee_details,$remark,$amount,$school_code)
    {
        
        $auto= new Automation();
        $common=new Common();
        $table='tm_fee_due_settlement_request';
        $col_id='settlement_request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $settlement_request_id='DSR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $arrFeeDetails = json_decode($fee_details, TRUE);

                    for ($i=0; $i <count($arrFeeDetails) ; $i++) { 

                        $monthIsChecked=$arrFeeDetails[$i]["isChecked"];
                        if($monthIsChecked=="true")
                        {

                        
                            $month=$arrFeeDetails[$i]['month'];
                            $applicable_fee=$arrFeeDetails[$i]['applicable_fee'];
                            $arrApplicable_fee = json_decode($applicable_fee, TRUE);
                        
                            for ($j=0; $j <count($arrApplicable_fee) ; $j++) { 
                                $isFeeChecked=$arrApplicable_fee[$j]['isChecked'];
                                if($isFeeChecked=="true")
                                {

                                $fee_id=$arrApplicable_fee[$j]['fee_id'];
                                $fee_value=$arrApplicable_fee[$j]['fee_value'];
                                $payable_amount=$arrApplicable_fee[$j]['payable_amount'];
                                $sql="INSERT INTO `tm_fee_due_settlement_request` (`id`,`school_code`, `settlement_request_id`, `sender_id`, `approved_by`, `student_id`, `session_id`, `class_id`, `section_id`, `fee_id`, `applicable_month`, `due_amount`, `due_payment_status`, `settlement_status`, `date_added`, `status`, `isTrashed`, `trashed_date`) 
                                VALUES (NULL,'$school_code', '$settlement_request_id', '$sender_id', NULL, '$student_id', '$session_id', '$class_id', '$section_id', '$fee_id', '$month', '$payable_amount', '1', '1', CURRENT_TIMESTAMP, 'Active', '0', NULL)";
                            
                                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding  settlement fee request:'.mysqli_error($this->conn));
                                }
                            }
                        }

                      
                }

                if($result)
                {
                    $title="Fee Settlement Request";
                    $message="New Fee Settlement Request is registered from student ".$common->getStudentName($student_id);
                    $sender_id="System";
                    $notification_type="Automation";
                    $click_action="admin.SettlementActivity";
                    $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code); 
                }

              return $result;    
    }

    public function AddClassFeeSettlementRequest($class_id,$section_id,$session_id,$sender_id,
        $fee_details,$remark,$settlement_status,$approved_by,$school_code)
    {
        
        $auto= new Automation();
        $common=new Common();
        $get=new getFunctions();
        $table='tm_fee_due_settlement_request';
        $col_id='settlement_request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $settlement_request_id='DSR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $sql="SELECT `student_enrollment_no` FROM `tm_student_class` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";
     
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                       
                        $student_id=$row['student_enrollment_no'];
                        $arrFeeDetails = json_decode($fee_details, TRUE);

                        for ($i=0; $i <count($arrFeeDetails) ; $i++) { 
                        $FeeIsChecked=$arrFeeDetails[$i]["isChecked"];
                        
                        if($FeeIsChecked=="true")
                        {

                            $fee_id=$arrFeeDetails[$i]['fee_id'];
                            $class_fee=$arrFeeDetails[$i]['fee_value']; 
                            $fee_value=$this->getStudentFeeValue($student_id,$class_id,$session_id,$fee_id,$class_fee,$school_code); 



                            $selectedMonth=$arrFeeDetails[$i]['selectedMonth'];
                            $arrSelectedMonth = explode(',', $selectedMonth);
                            
                            for ($j=0; $j <count($arrSelectedMonth) ; $j++) { 

                               
                                $month=$arrSelectedMonth[$j];
                                $settlement=$get->getDueSettlementStatus($student_id,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                if($settlement)
                                {
                                  
                                }
                                else{


                                $sql="INSERT INTO `tm_fee_due_settlement_request` (`id`,`school_code`, `settlement_request_id`, `sender_id`, `approved_by`, `student_id`, `session_id`, `class_id`, `section_id`, `fee_id`, `applicable_month`, `due_amount`, `due_payment_status`, `settlement_status`, `settlement_type`,`date_added`, `status`, `isTrashed`, `trashed_date`) 
                                VALUES (NULL,'$school_code', '$settlement_request_id', '$sender_id', '$approved_by', '$student_id', '$session_id', '$class_id', '$section_id', '$fee_id', '$month', '$fee_value', '1', '$settlement_status','CLASS_SETTLEMENT', CURRENT_TIMESTAMP, 'Active', '0', NULL)";
                            
                                  $result2=mysqli_query($this->conn,$sql)or die ('Error in adding  settlement fee request:'.mysqli_error($this->conn));
                                }
                                
                            }
                        }

                      
                }
                       
        }

        if($result2)
        {
                    $title="Class Fee Settlement Request";
                    $message="New Class Fee Settlement Request is registered from student ";
                    $sender_id="System";
                    $notification_type="Automation";
                    $click_action="admin.SettlementActivity";
                    $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code); 
        }

        return $result2;    
}

public function getStudentFeeValue($enrollment_no,$class_id,$session_id,$fee_id,$class_fee,$school_code)
{
       $get=new getFunctions();
       $fee_value=$class_fee;
       $special_case_fee=$get->isSpecialCase($enrollment_no,$class_id,$session_id,$fee_id,$school_code);
        if (strlen($special_case_fee)!= 0){

            $fee_value=$special_case_fee;
            
           
        }
        else{
            //normal case student
           $special_fee=$get->getSpecialFee($school_code);
           if($fee_id==$special_fee[0]['fee_id'])
            {
                //special fee
               $admission_type=$get->getAdmissionType($enrollment_no,$class_id,$session_id);
               if($admission_type=="ADMTYPE01")
               {
                    $regfee=$get->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);  
                    $fee_value=$regfee;         

               }
               else{
                    $fee_value=$class_fee;
                                
               }

          }
          else{
            //normal class fee
            $fee_value=$class_fee;
            
           
           }
            
        }
        return $fee_value;
}


public function AddFeeDay($session_id,$open_day,$close_day,$fine_day,$school_code)
    {
        $sql="UPDATE `tm_fee_day` SET `open_day` = '$open_day',`close_day`='$close_day',`fine_day`='$fine_day'  WHERE `school_code`='$school_code' AND `session_id`='$session_id'";

            $result=mysqli_query($this->conn,$sql)or die ('Error in updating Fee Day:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                $sql="INSERT INTO `tm_fee_day` (`id`, `school_code`, `session_id`, `open_day`, `close_day`, `fine_day`, `date_added`, `status`)
                 VALUES (NULL, '$school_code', '$session_id', '$open_day', '$close_day', '$fine_day', CURRENT_TIMESTAMP, 'Active')";

                $result2=mysqli_query($this->conn,$sql)or die ('Error in adding fee day:'.mysqli_error($this->conn));

                return $result2;
                
            }

        

    }

public function AddSchoolBillingAddress($school_code,$school_name,$firstname,$lastname,$phone,$address1,$address2,$landmark,$state,$city,$pincode,$version)
{
    $common=new Common();
    $table="tm_school_billing_address";
    $col_id='address_id';
    $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
    $address_id='ADR'.str_pad($UniqueId,5,'0',STR_PAD_LEFT);


    $name=$firstname.' '.$lastname;

      $sql="INSERT INTO `tm_school_billing_address` (`id`, `address_id`,`school_code`, `school_name`,`contact_name`, `contact_mobile`, `state_id`, `city_name`, `pincode`, `address_one`, `address_two`, `landmark`, `IsFromApp`, `AppVersion`, `date_added`, `status`) 
      VALUES (NULL,'$address_id', '$school_code','$school_name','$name', '$phone', '$state', '$city', '$pincode', '$address1', '$address2', '$landmark', 'App', '$version', NOW(), 'Active')";
          //echo $sql;die;
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding billing address: '.mysql_error());
                         mysqli_close($conn);

        if($result)
        {
            $sql="SELECT a.`address_id`,a.`school_code`,a.`school_name`,a.`contact_name`,a.`contact_mobile` ,a.`state_id`,c.`state_name`,a.`city_name`,a.`pincode`,a.`address_one`,a.`address_two`,a.`landmark` FROM `tm_school_billing_address` a  LEFT JOIN `tm_state_master` c ON a.`state_id`=c.`state_id` WHERE a.`address_id`='$address_id'";
            $result2=mysqli_query($this->conn,$sql)or die ('Error in getting  billing address : '.mysqli_error($this->conn));
            while ($row = $result2->fetch_assoc()) {
                        $data[] = $row;
                 }
                return $data;  
        }                 
        else{
           return $result;  
        }
                        
}


public function submitOrder($school_code,$product_code,$product_rate,$renewal_rate,$product_order_amount,$total_amount,$order_type,$service_validity,$tax_id,$tax_rate,$tax_amount,$promo_code_id,$promo_code,$promo_code_discount,$billing_address_id,$order_date,$payment_mode,$payment_remark,$payment_status)
{

   
    $common=new Common();
    $table="tm_crm_order";
    $col_id='order_id';
    $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
    $order_id='ODR'.str_pad($UniqueId,6,'0',STR_PAD_LEFT);

        $table="tm_crm_order";
        $col_id='invoice_id';
        $unique_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $invoice_id=''.str_pad($unique_id, 6,'0',STR_PAD_LEFT);

      $sql="INSERT INTO `tm_crm_order` (`id`, `order_id`, `invoice_id`, `school_code`, `product_code`, `product_rate`, `renewal_rate`, `product_order_amount`, `order_type`, `service_validity`, `tax_id`, `tax_rate`, `tax_amount`, `promo_code_id`, `promo_code`, `promo_code_discount`, `total_amount`,`billing_address_id`, `order_date`, `order_status`) 
      VALUES (NULL, '$order_id', '$invoice_id', '$school_code', '$product_code', '$product_rate', '$renewal_rate', '$product_order_amount', '$order_type', '$service_validity', '$tax_id', '$tax_rate', '$tax_amount', '$promo_code_id', '$promo_code', '$promo_code_discount', '$total_amount','$billing_address_id','$order_date', '1')";
          //echo $sql;die;
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding order: '.mysql_error());
                         mysqli_close($conn);

        if($result)
        {
            $transaction_data=$this->orderPayment($school_code,$order_id,$total_amount,$order_date,$payment_mode,$payment_remark,$payment_status);
            if($transaction_data)
            {
                 $sql="SELECT `order_id`,`invoice_id`,`school_code`,`product_code` FROM `tm_crm_order` WHERE `order_id`='$order_id'";
                 $result2=mysqli_query($this->conn,$sql)or die ('Error in getting  order placed : '.mysqli_error($this->conn));
                   while ($row = $result2->fetch_assoc()) {
                        $data[] = $row;
                 }
                return $data;
            }
            else{
                return false;
            }
           

        }                 
        else{
            return $result;
        }
           
                  
}
public function orderPayment($school_code,$order_id,$total_amount,$order_date,$payment_mode,$payment_remark,$payment_status)
{  
    $common=new Common();
    $table="tm_crm_order_payment";
    $col_id='transaction_id';
    $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
    $transaction_id='ETS'.str_pad($UniqueId,6,'0',STR_PAD_LEFT);

    $sql="INSERT INTO `tm_crm_order_payment` (`id`, `transaction_id`, `order_id`, `school_code`, `transaction_amount`, `payment_method`, `payment_remark`, `payment_status`, `payment_date`, `date_added`) 
    VALUES (NULL, '$transaction_id', '$order_id', '$school_code', '$total_amount', '$payment_mode', '$payment_remark', '$payment_status', '$order_date', CURRENT_TIMESTAMP)";
          //echo $sql;die;
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding order payment: '.mysql_error());
                         mysqli_close($conn);
     return $result; 
}

public function AddNewMasterSubjectPart($subject_id,$subject_part_name,$school_code)
{
        
         $common=new Common();
        $table='tm_subject_part';
        $col_id='subject_part_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $subject_part_id='SBTP'.str_pad($UniqueId, 3,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_subject_part` (`id`,`school_code`, `subject_id`,`subject_part_id`, `subject_part_name`, `date`, `status`) VALUES (NULL,'$school_code','$subject_id','$subject_part_id', '$subject_part_name', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in addind new subject part:'.mysqli_error($this->conn));

        

        return $result;
       

}

 public function AddClassSubjectPart($class_id,$subject_id,$strSubject_part_id,$school_code)
    {

        $session_id=$this->getCurrentSession($school_code);

        $arrSubject_part_id = json_decode($strSubject_part_id, TRUE);      
            for ($i=0; $i <count($arrSubject_part_id) ; $i++) 
            {


            if($arrSubject_part_id[$i]['selected'])
            {
                $subject_part_id=$arrSubject_part_id[$i]['subject_part_id'];

                $sql="INSERT INTO `tm_class_subject_part` (`id`,`school_code`, `session_id`, `class_id`, `subject_id`, `subject_part_id`, `subject_code`, `book_name`, `date_added`, `status`) 
               VALUES (NULL,'$school_code', '$session_id', '$class_id', '$subject_id', '$subject_part_id', NULL, NULL, CURRENT_TIMESTAMP, 'Active')";
                $result=mysqli_query($this->conn,$sql)or die ('Error in adding new subject in  class :'.mysqli_error($this->conn));
            }
              
        
            
           
            }
            

        

        return $result;

    }

    public function AddNewExamPaper($exam_id,$class_id,$section_id,$subject_id,$paper_name,$is_mark_system,$is_grade_system,$max_mark,$max_grade,$str_subject_part,$school_code)
    {
 
        $paper_name=addcslashes($paper_name, "'");
        
        $common=new Common();
        $table='tm_exam_paper';
        $col_id='exam_paper_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $exam_paper_id='EPR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_exam_paper` (`id`,`school_code`, `exam_paper_id`, `exam_paper_name`, `exam_id`, `class_id`, `section_id`, `subject_id`, `is_mark_system`, `max_mark`, `is_grade_system`, `max_grade`, `status`, `date_added`, `is_trashed`, `trash_date`) 
              VALUES (NULL,'$school_code','$exam_paper_id', '$paper_name', '$exam_id', '$class_id', '$section_id', '$subject_id', '$is_mark_system', '$max_mark', '$is_grade_system', '$max_grade', 'Active', CURRENT_TIMESTAMP, '0', NULL)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding  new  exam paper:'.mysqli_error($this->conn)); 
            if($result)
            {
                    $this->AddExamPaperDetails($exam_paper_id,$exam_id,$subject_id,$str_subject_part,$school_code);
            }

        return $result;

    }

     public function AddExamPaperDetails($exam_paper_id,$exam_id,$subject_id,$str_subject_part,$school_code)
    {
        $arrSubjectPart = json_decode($str_subject_part, TRUE); 
            for ($i=0; $i <count($arrSubjectPart) ; $i++) { 
                if($arrSubjectPart[$i]['isChecked']=="true")
                {
                    $isMarkSystem=$arrSubjectPart[$i]['isMarkSystem'];
                    if($isMarkSystem=="true")
                    {
                        $isMarkSystem="1";
                    }
                    else{
                        $isMarkSystem="0";
                    }
                    $isGradeSystem=$arrSubjectPart[$i]['isGradeSystem'];
                    if($isGradeSystem=="true")
                    {
                        $isGradeSystem="1";
                    }
                    else{
                        $isGradeSystem="0";
                    }
                   
                    $max_mark=$arrSubjectPart[$i]['MaxMark'];                   
                    $max_grade=$arrSubjectPart[$i]['MaxGrade'];

                    $subject_part_name=$arrSubjectPart[$i]['subject_part_name'];
                    $subject_part_id=$arrSubjectPart[$i]['subject_part_id'];

                    $sql="INSERT INTO `tm_exam_paper_details` (`id`,`school_code`, `exam_paper_id`, `exam_id`, `subject_id`, `subject_part_id`, `subject_part_name`, `is_mark_system`, `max_mark`, `is_grade_system`, `max_grade`, `status`, `date_added`, `is_trashed`, `trash_date`) 
                    VALUES (NULL,'$school_code','$exam_paper_id', '$exam_id', '$subject_id', '$subject_part_id', '$subject_part_name', '$isMarkSystem', '$max_mark', '$isGradeSystem', '$max_grade', 'Active', CURRENT_TIMESTAMP, '0', NULL)";
                    //echo $sql;

                  $result=mysqli_query($this->conn,$sql)or die ('Error in adding exam paper details:'.mysqli_error($this->conn));

                }
                
            }
        return $result;    
    }

    public function BatchShift($student_ids,$class_id,$section_id,$board_id,$medium_id,$old_session_id,$new_session_id,$school_code)
    {
        $get=new getFunctions();
        $admission_type_id="ADMTYPE01";
        $academic_mode="ACDM01";
        $registration_date=$get->getSessionStartDate($old_session_id,$school_code);

        $arrStudentIds = json_decode($student_ids, TRUE);

        for ($i=0; $i <count($arrStudentIds) ; $i++) { 
           
            $student_id=$arrStudentIds[$i]['student_enrollment_no'];
            $StuRollNo=$arrStudentIds[$i]['student_roll_no'];
         

           $sql="INSERT INTO `tm_student_class` (`id`,`school_code`, `student_enrollment_no`, `student_roll_no`, `session_id`, `class_id`, `section_id`, `board_id`, `medium_id`, `admission_type_id`, `academic_mode_id`, `registration_date`, `date_added`, `status`)
            VALUES (NULL, '$school_code','$student_id', '$StuRollNo', '$new_session_id', '$class_id', '$section_id', '$board_id', '$medium_id', '$admission_type_id', '$academic_mode', '$registration_date', CURRENT_TIMESTAMP, 'Active')";
           $result2=mysqli_query($this->conn,$sql)or die ('Error in inserting  batch shifting :'.mysqli_error($this->conn));
        }

       return $result2;
        
    }
    public function AddOldDue($student_id,$session_name,$due_amount,$remark,$school_code)
    {
 
        $common=new Common();
        $table='tm_fee_old_due_student';
        $col_id='due_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $due_id='OD'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_fee_old_due_student` (`id`, `school_code`, `student_id`, `due_id`, `session_name`, `amount`,  `remark`, `payment_status`, `date_added`, `status`) 
            VALUES (NULL, '$school_code', '$student_id', '$due_id', '$session_name', '$due_amount', '$remark', '1', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding old due:'.mysqli_error($this->conn)); 
            if($result)
            {
                   
            }

        return $result;

    }
     public function AddAttachmentDetails($server_ip,$document_dir,$document_name,$file_type,$document_type_id,$recipient_id,$subject_id,$topic,$description,$attachment_date,$session_id,$staff_id,$school_code)
    {
 
        $auto=new Automation();
        $topic=addcslashes($topic, "'");
        $description=addcslashes($description, "'");
        
        $common=new Common();
        $table='tm_attachment_documents';
        $col_id='attachment_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $attachment_id='FID'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
       
            $sql="INSERT INTO `tm_attachment_documents` (`id`,`school_code`,`staff_id`,`session_id`, `attachment_id`, `document_type_id`,`file_type`, `server_ip`, `document_dir`, `document_name`, `recipient_id`, `subject_id`, `topic`, `description`,`attachment_date`, `date_added`, `status`)
             VALUES (NULL,'$school_code','$staff_id','$session_id','$attachment_id', '$document_type_id','$file_type','$server_ip', '$document_dir', '$document_name', '$recipient_id', '$subject_id', '$topic', '$description','$attachment_date', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding attachment details:'.mysqli_error($this->conn)); 
            if($result)
            {
                  $auto->NotifyNewFileAttachment($recipient_id,$subject_id,$school_code); 
            }

        return $result;

    }
      public function AddAttachmentDownloadReport($attachment_id,$recipient_id,$school_code)
    {

        $auto=new Automation();

         $sql="SELECT `num_of_download` FROM `tm_attachment_download_report` WHERE `attachment_id`='$attachment_id' AND `recipient_id`='$recipient_id' AND `school_code`='$school_code' AND `status`='Active'";
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting Attachment Download Report: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }
         $count=$data[0]['num_of_download'];
         if($count)
         {
            $count=$count+1;
             $sql="UPDATE `tm_attachment_download_report` SET `num_of_download` = '$count' WHERE `attachment_id`='$attachment_id' AND `recipient_id`='$recipient_id' AND `school_code`='$school_code'";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating attachment download report:'.mysqli_error($this->conn)); 
         }
         else{
            $sql="INSERT INTO `tm_attachment_download_report` (`id`, `school_code`, `attachment_id`, `recipient_id`, `num_of_download`, `date_added`, `status`) 
            VALUES (NULL, '$school_code', '$attachment_id', '$recipient_id', '1', CURRENT_TIMESTAMP, 'Active');";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding attachment download report:'.mysqli_error($this->conn)); 
            
         }

         if($result)
         {
            $auto->NotifyAttachmentDownloadToAdmin($attachment_id,$recipient_id,$school_code);
         }
            

        return $result;

    }

    public function submitErrorReport($error,$error_type,$sender_id,$source,$remark,$school_code)
    {
 
      
        $error2=addcslashes($error, "'");
        $common=new Common();
        $table='tm_error_report';
        $col_id='error_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $error_id='ER'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_error_report` (`id`, `school_code`, `error_id`, `error`, `sender_id`, `source`,`error_type`,`isSolved`,`remark`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$error_id', '$error2', '$sender_id', '$source','$error_type','0','$remark', 'Active', CURRENT_TIMESTAMP)";
            //echo $sql;
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding error report:'.mysqli_error($this->conn)); 
            if($result)
            {
                   
            }

        return $result;

    }

public function AddAdmissionInquiry($session_id,$student_name,$gender,$community,$religion,$nationality,$previous_school_name,$board_id,$medium_id,$previous_class,$previous_class_id,$query_class,$query_class_id,$father_name,$contact_number,$address,$remark,$school_code)
{


        $common=new Common();
        $table='tm_admission_request';
        $col_id='request_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $request_id='AI'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $sql="INSERT INTO `tm_admission_request` (`id`, `school_code`, `request_id`, `session_id`, `student_name`, `gender`, `community`, `religion`, `nationality`, `previous_school_name`, `board_id`, `medium_id`, `previous_class`, `previous_class_id`, `query_class`, `query_class_id`, `father_name`, `contact_number`, `address`, `remark`, `date_added`, `status`) 
        VALUES (NULL, '$school_code', '$request_id', '$session_id', '$student_name', '$gender', '$community', '$religion', '$nationality', '$previous_school_name', '$board_id', '$medium_id', '$previous_class', '$previous_class_id', '$query_class', '$query_class_id', '$father_name', '$contact_number', '$address', '$remark', CURRENT_TIMESTAMP, 'Active')";
        
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding  admission inquiry :'.mysqli_error($this->conn));

        return $result;
}
public function saveAttachmentExercise($staff_id,$attachment_id,$class_id,$section_id,$subject_id,$session_id,$exercise,$img_dir_toupload,$exercise_date,$school_code)
{

        $common=new Common();
        $table='tm_attachment_exercise';
        $col_id='exercise_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);
        $exercise_id='EXCR'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $sql="INSERT INTO `tm_attachment_exercise` (`id`, `school_code`, `exercise_id`, `staff_id`, `attachment_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `exercise_date`, `exercise_img`, `exercise`, `date_added`, `status`) 
        VALUES (NULL, '$school_code', '$exercise_id', '$staff_id', '$attachment_id', '$session_id', '$class_id', '$section_id', '$subject_id', '$exercise_date', '$img_dir_toupload', '$exercise', CURRENT_TIMESTAMP, 'Active')";
        
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding  attachment excerxise :'.mysqli_error($this->conn));

        return $result;
}

 public function addExpenseEntry($session_id,$amount,$entry_date,$category_id,$category_name,$party_id,$party_name,$remark,$entry_type,$school_code)
    {

            $common=new Common();
            $auto=new Automation();
            if(empty($category_id) && !empty($category_name))
            {
                
                 $table='tm_daybook_category';
                 $col_id='category_id';
                 $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);               
                 $category_id='DBC'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
                 $sql2="INSERT INTO `tm_daybook_category` (`id`, `school_code`, `category_id`, `category_name`, `status`, `date_added`) 
                 VALUES (NULL, '$school_code', '$category_id', '$category_name', 'Active', CURRENT_TIMESTAMP)";               
        
               $result2=mysqli_query($this->conn,$sql2)or die ('Error in adding day book category  :'.mysqli_error($this->conn));
            }
            if(empty($party_id) && !empty($party_name))
            {
                
                 $table='tm_daybook_party';
                 $col_id='party_id';
                 $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);               
                 $party_id='DBP'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
                 $sql3="INSERT INTO `tm_daybook_party` (`id`, `school_code`, `party_id`, `party_name`, `address`, `phone`, `status`, `date_added`) 
                 VALUES (NULL, '$school_code', '$party_id', '$party_name', '', '', 'Active', CURRENT_TIMESTAMP)";               
        
               $result3=mysqli_query($this->conn,$sql3)or die ('Error in adding day book party  :'.mysqli_error($this->conn));
            }
           
                 
            
             $table='tm_daybook_entry';
             $col_id='entry_id';
             $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);               
             $entry_id='DBE'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);     

            $sql="INSERT INTO `tm_daybook_entry` (`id`, `school_code`, `session_id`, `entry_id`, `party_id`, `category_id`, `amount`, `entry_date`, `entry_type`, `remark`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$session_id', '$entry_id', '$party_id', '$category_id', '$amount', '$entry_date', '$entry_type', '$remark', 'Active', CURRENT_TIMESTAMP)";
            
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new  day book entry :'.mysqli_error($this->conn)); 

            if($result)
            {

                $title="Day Book";
                $message="New day book entry of  Rs ".$amount." is added successfully";
                $sender_id="System";
                $notification_type="Automation";
                $click_action="cms.DayBookActivity";
                $auto->sendNotificationToAdmin($title,$message,$sender_id,$notification_type,$click_action,$school_code);
            }   

          return $result;
 
    }


    
public function AddStaffPayRollDetails($staff_id,$opening_balance_type,$opening_balance_amount,$payment_type_id,$salary,$salary_circle,$working_hour,$session_id,$joining_date,$week_off,$is_sms_alert,$school_code)
{


        $sql="INSERT INTO `tm_payroll_staff_details` (`id`, `school_code`, `staff_id`, `payment_type_id`, `salary`, `salary_circle`, `working_hour`, `joining_date`, `week_off`, `is_sms_alert`, `status`, `date_added`) VALUES (NULL, '$school_code', '$staff_id', '$payment_type_id', '$salary', '$salary_circle', '$working_hour', '$joining_date', '$week_off', '$is_sms_alert', 'Active', CURRENT_TIMESTAMP)";
        
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding  Staff Payroll Details :'.mysqli_error($this->conn));
        if($result)
        {
            $this->AddStaffOpeningBalance($staff_id,$opening_balance_type,$opening_balance_amount,$session_id,$school_code);
             $this->AddStaffSalary($staff_id,$payment_type_id,$salary,$joining_date,$school_code);
            
        }

        return $result;
}

public function AddStaffOpeningBalance($staff_id,$opening_balance_type,$opening_balance_amount,$session_id,$school_code)
{
        $sql="INSERT INTO `tm_payroll_opening_balance` (`id`, `school_code`, `session_id`, `staff_id`, `opening_balance_type`, `opening_balance_amount`, `status`, `date_added`) 
        VALUES (NULL, '$school_code', '$session_id', '$staff_id', '$opening_balance_type', '$opening_balance_amount', 'Active', CURRENT_TIMESTAMP)";
        
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding  Staff Payroll opening balance :'.mysqli_error($this->conn));
        
        return $result;
}
public function AddStaffSalary($staff_id,$payment_type_id,$salary,$joining_date,$school_code)
{

    $get=new getFunctions();
    $today=date('Y-m-d');  
    $count=$get->getNoOfMonth($joining_date,$today);
    
    for ($i=0; $i <=$count ; $i++) { 

            $month=date("Y-m",strtotime("+$i Months,$joining_date"));
            $month2=date("F-Y",strtotime("+$i Months,$joining_date"));

            $date=date("Y-m-d",strtotime("+$i Months,$joining_date"));
           
            $session_id=$this->getSessionByDate($date,$school_code);
            

        $sql="INSERT INTO `tm_payroll_staff_salary` (`id`, `school_code`,`session_id`, `staff_id`, `payment_type_id`, `salary`, `month`,`month2`, `staff_present`, `staff_absent`, `staff_leave`, `paid_leave`, `week_off`, `holiday`, `net_salary`, `status`, `date_added`) 
        VALUES (NULL, '$school_code','$session_id', '$staff_id', '$payment_type_id', '$salary', '$month','$month2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Active', CURRENT_TIMESTAMP)";
        
        $result=mysqli_query($this->conn,$sql)or die ('Error in adding  Staff Payroll salary :'.mysqli_error($this->conn));
    }
        
   return $result;
}
public function getStaffAttendance($staff_id,$month)
{

     $sql="SELECT `staff_id`,COUNT(Case When `attendance`= 'P' Then `attendance` End) total_present FROM `tm_staff_attendance` WHERE `staff_id`='$staff_id' AND INSTR( `attendance_date`, '$month' ) ";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff attendance: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                
                $data[] = $row;
         }
     
     return $data;    
}
public function AddSchoolReferralLogs($user_id,$school_code)
{
      $sql="INSERT INTO `tm_crm_referral_logs` (`id`, `school_code`, `user_id`, `date_added`, `status`) 
      VALUES (NULL, '$school_code', '$user_id', CURRENT_TIMESTAMP, 'Active');";

                $result2=mysqli_query($this->conn,$sql)or die ('Error in adding referral logs :'.mysqli_error($this->conn));

                return $result2;
}


public function AddExamDateSheet($session_id,$exam_id,$class_id,$section_id,$subject_id,$subject_paper_id,$exam_date,$exam_time,$exam_shift,$school_code)
    {

        $common=new Common();
        $table='tm_exam_datesheet';
        $col_id='datesheet_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);   
        $datesheet_id='DTS'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_exam_datesheet` (`id`, `school_code`, `datesheet_id`,`session_id`, `exam_id`, `class_id`, `section_id`, `subject_id`, `subject_paper_id`, `exam_date`, `exam_shift`, `exam_time`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$datesheet_id','$session_id','$exam_id', '$class_id', '$section_id', '$subject_id', '$subject_paper_id', '$exam_date', '$exam_shift', '$exam_time', 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding date sheet :'.mysqli_error($this->conn)); 

        return $result;

    }

public function AddExamGuideline($session_id,$exam_id,$class_id,$section_id,$guideline,$school_code)
    {
        $guideline=addcslashes($guideline, "'");
        $common=new Common();
        $table='tm_exam_guideline';
        $col_id='guideline_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);   
        $guideline_id='GDL'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

            $sql="INSERT INTO `tm_exam_guideline` (`id`, `school_code`, `guideline_id`, `session_id`, `exam_id`, `class_id`, `section_id`, `guideline`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$guideline_id', '$session_id', '$exam_id', '$class_id', '$section_id', '$guideline', 'Active',CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding exam guideline :'.mysqli_error($this->conn)); 

        return $result;

    }

    public function AddFeeSettlementValidation($settlement_request_id,$student_id,$session_id,$class_id,$section_id,$fee_id,$applicable_month,$settlement_amount,$fee_value,$remark,$school_code)
    {

            $sql="INSERT INTO `tm_validation_fee_settlement` (`id`, `school_code`, `settlement_request_id`, `student_id`, `session_id`, `class_id`, `section_id`, `fee_id`, `applicable_month`, `settlement_amount`, `fee_value`, `remark`, `date_added`, `status`) 
            VALUES (NULL, '$school_code', '$settlement_request_id', '$student_id', '$session_id', '$class_id', '$section_id', '$fee_id', '$applicable_month', '$settlement_amount', '$fee_value', '$remark', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding fee settlement validation:'.mysqli_error($this->conn)); 

        return $result;

    }

    public function AddClassChangeLogs($staff_id,$student_enrollment_no,$existing_class_id,$existing_section_id,$new_class_id,$new_section_id,$session_id,$school_code)
    {

        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $table='tm_log_change';
        $col_id='change_log_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);   
        $change_log_id='CL'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

        $changing_field="class_id".'#'."section_id";
        $field_value=$existing_class_id.'#'.$existing_section_id;
        $new_field_value=$new_class_id.'#'.$new_section_id;

        if($existing_section_id=='No')
        {
            if($new_section_id=='No')
            {
                $change_text="Class of student ".$common->getStudentName($student_enrollment_no)."(".$student_enrollment_no.") changed from ".$common->getClassName($existing_class_id,$session_id,$school_code)." to ".$common->getClassName($new_class_id,$session_id,$school_code).' By Staff '.$get->getStaffName($staff_id);
            }
            else{
                $change_text="Class of student ".$common->getStudentName($student_enrollment_no)."(".$student_enrollment_no.") changed from ".$common->getClassName($existing_class_id,$session_id,$school_code)." to ".$common->getClassName($new_class_id,$session_id,$school_code).':'.$common->getSectionName($new_class_id,$new_section_id,$session_id,$school_code).' By Staff '.$get->getStaffName($staff_id); 
            }
           
        }
        else{
            if($new_section_id=='No')
            {
                $change_text="Class of student ".$common->getStudentName($student_enrollment_no)."(".$student_enrollment_no.") changed from ".$common->getClassName($existing_class_id,$session_id,$school_code).':'.$common->getSectionName($existing_class_id,$existing_section_id,$session_id,$school_code)." to ".$common->getClassName($new_class_id,$session_id,$school_code).' By Staff '.$get->getStaffName($staff_id);
            }
            else{
                $change_text="Class of student ".$common->getStudentName($student_enrollment_no)."(".$student_enrollment_no.") changed from ".$common->getClassName($existing_class_id,$session_id,$school_code).':'.$common->getSectionName($existing_class_id,$existing_section_id,$session_id,$school_code)." to ".$common->getClassName($new_class_id,$session_id,$school_code).':'.$common->getSectionName($new_class_id,$new_section_id,$session_id,$school_code).' By Staff '.$get->getStaffName($staff_id); 
            }

             
        }
       
        $sql="INSERT INTO `tm_log_change` (`id`, `school_code`, `change_log_id`, `session_id`, `staff_id`, `student_id`, `change_text`, `changing_field`,`field_value`,`new_field_value`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$change_log_id', '$session_id', '$staff_id', '$student_enrollment_no', '$change_text', '$changing_field', '$field_value', '$new_field_value',  'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding class change log :'.mysqli_error($this->conn)); 

         if($result)
         {
            $auto->NotifyLogChangeToAdmin($change_text,$school_code);
         }   

        return $result;

    }


    public function AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code)
    {

        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $table='tm_log_change';
        $col_id='change_log_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);   
        $change_log_id='CL'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);

    
        
       
        $sql="INSERT INTO `tm_log_change` (`id`, `school_code`, `change_log_id`, `session_id`, `staff_id`, `student_id`, `change_text`, `changing_field`,`field_value`,`new_field_value`, `status`, `date_added`) 
            VALUES (NULL, '$school_code', '$change_log_id', '$session_id', '$staff_id', '$student_enrollment_no', '$change_text', '$changing_field', '$field_value', '$new_field_value',  'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding class change log :'.mysqli_error($this->conn)); 

         if($result)
         {
            $auto->NotifyLogChangeToAdmin($change_text,$school_code);
         }   

        return $result;

    }

    public function AddDeleteLogs($staff_id,$student_enrollment_no,$delete_text,$session_id,$school_code)
    {

        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $table='tm_log_delete';
        $col_id='delete_log_id';
        $UniqueId=$common->getUniqueId_No_Hyphen2($table,$col_id,$school_code);   
        $delete_log_id='DLT'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
  
        $sql="INSERT INTO `tm_log_delete` (`id`, `school_code`, `delete_log_id`, `session_id`, `staff_id`, `student_id`, `delete_text`, `backup_success`, `delete_success`, `status`, `date_added`)
         VALUES (NULL, '$school_code', '$delete_log_id', '$session_id', '$staff_id', '$student_enrollment_no', '$delete_text', '0', '0', 'Active', CURRENT_TIMESTAMP)";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding delete  log :'.mysqli_error($this->conn)); 

            if($result)
            {
                 return $delete_log_id;
            }
            else{
                return false;
            }
       

    }

    public function AddNewAcademicSyllabus($staff_id,$document_type,$file_type,$class_id,$section_id,$subject_id,$session_id,$description,$new_name,$img_dir,$school_code)
    {
 
        $dbget=new getFunctions();
        $auto=new Automation();
        $description=addcslashes($description, "'");
        
        $common=new Common();
        $table='tm_academic_syllabus';
        $col_id='syllabus_id';
        $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
        $syllabus_id='SLB'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
       
            $sql="INSERT INTO `tm_academic_syllabus` (`id`, `school_code`, `syllabus_id` ,`staff_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `document_type`, `file_type`, `document_dir`, `document_name`, `description`, `date_added`, `status`) 
            VALUES (NULL, '11','$syllabus_id', '$staff_id', '$session_id', '$class_id', '$section_id', '$subject_id', '$document_type', '$file_type', '$img_dir', '$new_name', '$description', CURRENT_TIMESTAMP, 'Active')";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in adding new academic syllabus:'.mysqli_error($this->conn)); 
            if($result)
            {
                $subject_name=$dbget->getSubjectName($subject_id,$school_code);
                $title="Academic Syllabus";
                $message="New Academic Syllabus of subject ".$subject_name." is uploaded";
                $sender_id="System";
                $notification_type="Automation";
                $click_action="parents.ParentsAcademicSyllabusActivity";
                $recipient=$class_id.'#'.$section_id;
                $auto->sendNotificationToStudent($recipient,$title,$message,$sender_id,$notification_type,$click_action,$school_code); 
            }

        return $result;

    }




    

}
?>

