<?php
class Automation{


	function __construct() {
        
        require_once ('firebase.php');
	 	require_once ('push.php');
	 	require_once ('getFunctions.php');
	 	require_once ('setFunctions.php');
        require_once ('getFunctionsCRM.php');
        require_once ('Common.php');

        
    }

    public function NotifyNoticeAdd($strRecipient,$staff_id,$school_code)
    {
        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset=new setFunctions();
        $common=new Common();
        

            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
        $title ="New Notice";
        $message ='New Notice is added ';
        $department="Management";
        
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="parents.ParentsNoticeActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
        $notification_type="Manual";
        $sender_id=$staff_id;
        $table='tm_notification_master';
        $col_id='notification_bucket_id';
        $notification_bucket_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $notification_bucket_caption=$message;

       
    
        $data=$dbset->addNotification($strRecipient,$message,$title,$sender_id,$department,$notification_type,$notification_bucket_id,$notification_bucket_caption,$school_code);
        if($data)
        {

            $regId =$dbget->getFirebaseTokenId($strRecipient,$school_code);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
           // echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
            echo json_encode($response);
        }

    }


	public function NotifyStudentLeaveStatus($applicant_id,$staff_id,$status,$start_date,$end_date,$school_code)
	{
        
		$firebase = new Firebase();
    	$push = new Push();
    	$dbget=new getFunctions();
    	$dbset=new setFunctions();
        $common=new Common();
		
		$arrRecipient = array();
		$arrRecipient[0]=$applicant_id;
		$recipient=json_encode($arrRecipient);


		    // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
        $title ="Leave Application";
        $message ='Your Application for leave from '.$start_date." to ".$end_date." is ".$status;
      	$department="Management";
      	
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="parents.ParentsLeaveListActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
        $notification_type="Automation";
        $sender_id="System";


        $table='tm_notification_master';
        $col_id='notification_bucket_id';
        $notification_bucket_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $notification_bucket_caption=$message;
       
        $data=$dbset->addNotification($recipient,$message,$title,$sender_id,$department,$notification_type,$notification_bucket_id,$notification_bucket_caption,$school_code);
        if($data)
        {

            $regId =$dbget->getFirebaseTokenId($recipient,$school_code);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
           // echo json_encode($response);
        }

	}

   


    public function  NotifyStudentAttendance($staff_id,$strAttendence,$class_id,$section_id,$date,$school_code)
    {
    
        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset=new setFunctions();
        $common=new Common();
        
       

            // optional payload
        $fields = array();
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';

         $title ="Attendance Report";
         $department="Management";
         $className=$common->getClassName($class_id);
         if($section_id!="No")
         {
                $section_name=$common->getSectionName($section_id);
         }

        $table='tm_notification_master';
        $col_id='notification_bucket_id';
        $notification_bucket_id=$common->getUniqueId_No_Hyphen($table,$col_id);
         


        $arrAttendence = json_decode($strAttendence, TRUE);
        for ($i=0; $i <count($arrAttendence) ; $i++) { 
            $enroll_no=$arrAttendence[$i]['student_enrollment_no'];
            $attendence=$arrAttendence[$i]['attendence'];

            $student_name=$common->getStudentName($enroll_no);
            if($attendence=="P")
            {

                if($section_id!="No")
                 {
                    $message ='Attendance of Class '.$className.":".$section_name." is taken on date:"
                    .$date.". Your child ".$student_name." is present in class";
                 }
                 else{
                    $message ='Attendance of Class '.$className." is taken on date:"
                    .$date.". Your child ".$student_name." is present in class";
                 }
                 
            }
            else if($attendence=="A")
            {

                if($section_id!="No")
                 {
                    $message ='Attendance of Class '.$className.":".$section_name." is taken on date:"
                    .$date.". Your child ".$student_name." is absent in class";
                 }
                 else{
                    $message ='Attendance of Class '.$className." is taken on date:"
                    .$date.". Your child ".$student_name." is absent in class";
                 }
            }
            else if($attendence=="L")
            {
                if($section_id!="No")
                 {
                    $message ='Attendance of Class '.$className.":".$section_name." is taken on date:"
                    .$date.". Your child ".$student_name." is on leave";
                 }
                 else{
                    $message ='Attendance of Class '.$className." is taken on date:"
                    .$date.". Your child ".$student_name." is on leave";
                 }

            }

            $push->setTitle($title);
            $push->setMessage($message);
            $push->setImage('');
            $push->setIsBackground(FALSE);
            $push->setPayload($payload);
            $click_action="parents.ParentsAttendanceActivity";
            $push->setClickAction($click_action);
       
                $json = '';
                $res = '';
                $json = $push->getPush();
      

            $arrRecipient = array();
            $arrRecipient[0]=$enroll_no;
            $recipient=json_encode($arrRecipient);
         
        $notification_type="Automation";  
        $notification_bucket_caption='Attendance of Class '.$className.":".$section_name." is taken on date:"
                    .$date;


        $data=$dbset->addNotification($recipient,$message,$title,$staff_id,$department,$notification_type,$notification_bucket_id,$notification_bucket_caption,$school_code);
        if($data)
        {

            $regId =$dbget->getFirebaseTokenId($recipient,$school_code);

            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
            //echo json_encode($response);
        }
           
            
    } 

    
}



    public function NotifyNewSchoolRegistration($school_code)
    {
        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctionsCRM();

        $school_name=$dbget->getSchoolName($school_code);
        
        
    


            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
        $title ="New Registration";
        $message ='A new school '.$school_name." is registered ";
      
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="com.techmetrica.apps.codegenius.eduok_gold.crm.CrmMySchoolsActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
       
            $regId =$dbget->getEduOKAdminFirebaseId();

            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);

    }


    public function NotifyNewQueryRegistration($school_code)
    {
       
        $firebase = new Firebase();       
        $push = new Push();
        $dbget_crm=new getFunctionsCRM();
        $school_name=$dbget_crm->getSchoolName($school_code);
       
            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
        $title ="New Query";
        $message ='A new query is registered from school'.$school_name." school code:".$school_code;
      
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="com.techmetrica.apps.codegenius.eduok_gold.crm.CrmSchoolQueryActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
       
            $regId =$dbget_crm->getEduOKAdminFirebaseId();

            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);

    }
    public function NotifyAdminFeeSettlementRequest($student_id,$class_id,$section_id,$session_id,$sender_id,$amount,$school_code)
    {

        /*$firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset=new setFunctions();
        
        $arrRecipient = array();
        $arrRecipient[0]="ALL_ADMIN";
        $recipient=json_encode($arrRecipient);


            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
        $title ="Fee Settlement Request";
        $student_name=$dbget->getStudentName($student_id);
        $message ='New Fee Settlement Request is registered from student '.$student_name;        
        $department="Management";
        
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="admin.LeaveManagementAdminActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
       

        $sender_id="System";
        $notification_type="Automation";
       
        $data=$dbset->addAdminNotification($strRecipient,$message,$title,$sender_id,$notification_type,$school_code);
        if($data)
        {

            $regId =$dbget->getAdminFirebaseId($recipient);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
            echo json_encode($response);
        }*/

        

    }

     public function NotifyQueryReply($sender_id,$parent_query_id,$school_code)
    {
        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset_crm=new setFunctionsCRM();
        $dbget_crm=new getFunctionsCRM();
        $common=new Common();
        

        $recipient_id=$common->getQueryReplyRecipientId($parent_query_id);
        
            /*$arrRecipient = array();
            $arrRecipient[0]=$recipient_id;
            $strRecipient=json_encode($arrRecipient);*/

            $arrRecipient = array();
            $arrRecipient[0]="ALL_ADMIN";
            $recipient=json_encode($arrRecipient);


                // optional payload
            $payload = array();
            $payload['team'] = 'techmetrica.com';
            $payload['city'] = 'noida';
           

            
     
            // notification title
            $title ="Query Reply";
            $staff_name=$dbget_crm->getEduOkAdminName($sender_id);
            $message ='New Query reply is added from '.$staff_name;
            
            
            $response = array("api_status" => "ERROR");      
            $push->setTitle($title);
            $push->setMessage($message);
            $push->setImage('');
            $push->setIsBackground(FALSE);
            $push->setPayload($payload);
            $click_action="eduok.QueryActivity";
            $push->setClickAction($click_action);
           
     
            $json = '';
            $res = '';
            $json = $push->getPush();
            //print_r($json);
           

        
        $sender_id=$sender_id;
        $notification_type="Manual";
       
        $data=$dbset_crm->addCrmNotification($recipient,$message,$title,$sender_id,$notification_type,$school_code);
        if($data)
        {

            $regId =$common->getSchoolAdminFirebaseId($recipient,$school_code);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
           // echo json_encode($response);
        }


    }

    public function NotifyQueryReplyEduOKAdmin($sender_id)
    {
       
        $firebase = new Firebase();       
        $push = new Push();
        $dbget_crm=new getFunctionsCRM();
        
       
            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
            $title ="Query Reply";
            $staff_name=$dbget_crm->getEduOkAdminName($sender_id);
            $message ='New Query reply is added from '.$staff_name;
      
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="com.techmetrica.apps.codegenius.eduok_gold.crm.CrmSchoolQueryActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
       
            $regId =$dbget_crm->getEduOKAdminFirebaseId_Except($sender_id);

            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);

    }
    public function NotifyLeaveApplicationToAdmin($applicant_id,$applicant_type,$school_code)
    {
        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset=new setFunctions();
        $common=new Common();
        
        $arrRecipient = array();
        $arrRecipient[0]="ALL_ADMIN";
        $recipient=json_encode($arrRecipient);


            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        // notification title
        $title ="Leave Application";
        if($applicant_type=="Student")
        {
            $student_name=$dbget->getStudentName($applicant_id);
            $message ='New Application for leave is registered from student '.$student_name;
        }
        else{
            $staff_name=$dbget->getStaffName($applicant_id);
            $message ='New Application for leave is registered from staff '.$staff_name;
        }
        
        $department="Management";
        
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="admin.LeaveManagementAdminActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
       

        $sender_id="System";
        $notification_type="Automation";
       
        $data=$dbset->addAdminNotification($recipient,$message,$title,$sender_id,$notification_type,$school_code);
        if($data)
        {

            $regId =$common->getSchoolAdminFirebaseId($recipient,$school_code);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
            echo json_encode($response);
        }

    }

     public function NotifyNewFileAttachment($strRecipient,$subject_id,$school_code)
    {
        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset=new setFunctions();
        $common=new Common();

        

            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';
       
 
        $subject_name=$dbget->getSubjectName($subject_id,$school_code);
        // notification title
        $title ="New Learning Material";
        $message ="New Learning Material of subject ".$subject_name." is added";
        $department="Management";
        
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="parents.ParentsFileAttachmentActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
        $notification_type="Automation";
        $sender_id="System";

        $table='tm_notification_master';
        $col_id='notification_bucket_id';
        $notification_bucket_id=$common->getUniqueId_No_Hyphen($table,$col_id);
        $notification_bucket_caption=$message;

       
    
        $data=$dbset->addNotification($strRecipient,$message,$title,$sender_id,$department,$notification_type,$notification_bucket_id,$notification_bucket_caption,$school_code);
        if($data)
        {

            $regId =$dbget->getFirebaseTokenId($strRecipient,$school_code);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
            echo json_encode($response);
        }

    }


   public function NotifyAttachmentDownloadToAdmin($attachment_id,$recipient_id,$school_code)
    {

        $firebase = new Firebase();
        $push = new Push();
        $dbget=new getFunctions();
        $dbset=new setFunctions();
        $common=new Common();
        
        $arrRecipient = array();
        $arrRecipient[0]="ALL_ADMIN";

        $staff_id=$dbget->getStaffWhoAddedAttachment($school_code,$attachment_id);
        $arrRecipient[1]=$staff_id;       
        $recipient=json_encode($arrRecipient);

        $subject_id=$dbget->getSubjectOfAttachment($school_code,$attachment_id);
        $subject_name=$dbget->getSubjectName($subject_id,$school_code);


            // optional payload
        $payload = array();
        $payload['team'] = 'techmetrica.com';
        $payload['city'] = 'noida';


       
 
        // notification title
        $title ="Learning Management";      
        $student_name=$dbget->getStudentName($applicant_id); 
        if($student_name !== '')
        {
            $message =$student_name.'Downloaded Learning Material Of Subject '.$subject_name;
 
        }
        else{
            $staff_name=$dbget->getStaffName($applicant_id);
            $message =$staff_name.'Downloaded Learning Material Of Subject '.$subject_name;

        }
        
        $department="Management";        
        $response = array("api_status" => "ERROR");
      
        $push->setTitle($title);
        $push->setMessage($message);
        $push->setImage('');
        $push->setIsBackground(FALSE);
        $push->setPayload($payload);
        $click_action="admin.LeaveManagementAdminActivity";
        $push->setClickAction($click_action);
       
 
        $json = '';
        $res = '';
        $json = $push->getPush();
        //print_r($json);
       

        $sender_id="System";
        $notification_type="Automation";
       
        $data=$dbset->addAdminNotification($recipient,$message,$title,$sender_id,$notification_type,$school_code);
        if($data)
        {

            $regId =$common->getSchoolAdminFirebaseId($recipient,$school_code);
            $res = $firebase->sendMultiple($regId, $json);
            
            $response["api_status"] = "OK";
            $response["Response"] =$res; 
            //echo json_encode($response);
        }
        else{

            $response["api_status"] = "ERROR";
            $response["api_remark"] = "Problem in sending message !!!";
            echo json_encode($response);
        }

    }   
	
}

?>